/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.classloader;

import com.ibm.ws.kernel.boot.classloader.ClassLoaderHook;
import com.ibm.ws.kernel.boot.classloader.SharedClassCacheHook;
import java.lang.reflect.Method;

public class ClassLoaderHookFactory {
    private static final boolean doesJDKSupportSharedClasses;
    private static final boolean isSharingEnabled;

    public static ClassLoaderHook getClassLoaderHook(ClassLoader loader) {
        return doesJDKSupportSharedClasses && isSharingEnabled ? SharedClassCacheHook.newInstance(loader) : null;
    }

    static {
        boolean supported = false;
        boolean sharingEnabled = false;
        try {
            Class<?> sharedClass = Class.forName("com.ibm.oti.shared.Shared");
            supported = true;
            Method m = sharedClass.getDeclaredMethod("isSharingEnabled", new Class[0]);
            Boolean isSharing = (Boolean)m.invoke(sharedClass, new Object[0]);
            sharingEnabled = isSharing;
        }
        catch (Exception exception) {
            // empty catch block
        }
        doesJDKSupportSharedClasses = supported;
        isSharingEnabled = sharingEnabled;
    }
}

