/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.archive;

import com.ibm.ws.kernel.boot.Debug;
import com.ibm.ws.kernel.boot.archive.Archive;
import com.ibm.ws.kernel.boot.security.WLPDynamicPolicy;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Policy;
import java.util.ArrayList;

public class ArchiveFactory {
    private static final String PAX_ARCHIVE_CLASS_NAME = "com.ibm.ws.kernel.boot.archive.internal.PaxArchive";
    private static final String ZIP_ARCHIVE_CLASS_NAME = "com.ibm.ws.kernel.boot.archive.internal.ZipArchive";
    private static final URL ARCHIVE_IMPL_BUNDLE_URL;

    public static Archive create(String archivePath) throws IOException {
        File archiveFile = new File(archivePath);
        return ArchiveFactory.create(archiveFile);
    }

    public static Archive create(File archiveFile) throws IOException {
        if (!archiveFile.isAbsolute()) {
            throw new IllegalArgumentException(archiveFile.getPath());
        }
        String className = archiveFile.getName().endsWith(".pax") ? PAX_ARCHIVE_CLASS_NAME : ZIP_ARCHIVE_CLASS_NAME;
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{ARCHIVE_IMPL_BUNDLE_URL});
            Class<?> archiveImplClass = loader.loadClass(className);
            Constructor<?> ctor = archiveImplClass.getConstructor(File.class);
            return (Archive)ctor.newInstance(archiveFile);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public static Archive create(File archiveFile, boolean j2security) throws IOException {
        Archive arch = null;
        if (j2security) {
            ArrayList<URL> urlList = new ArrayList<URL>();
            urlList.add(ARCHIVE_IMPL_BUNDLE_URL);
            WLPDynamicPolicy wlpPolicy = new WLPDynamicPolicy(Policy.getPolicy(), urlList);
            Policy.setPolicy(wlpPolicy);
            ((Policy)wlpPolicy).refresh();
            arch = ArchiveFactory.create(archiveFile);
        } else {
            arch = ArchiveFactory.create(archiveFile);
        }
        return arch;
    }

    static {
        URL u = ArchiveFactory.class.getProtectionDomain().getCodeSource().getLocation();
        String path = u.toExternalForm();
        path = path.replaceAll("com.ibm.ws.kernel.boot_", "com.ibm.ws.kernel.boot.archive_");
        path = path.replaceAll("/com.ibm.ws.kernel.boot.core/build/classes/", "/com.ibm.ws.kernel.boot.archive/build/classes/");
        try {
            u = new URL(path);
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
            u = null;
        }
        ARCHIVE_IMPL_BUNDLE_URL = u;
    }
}

