/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.openpgp.IntegrityProtectedInputStream;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.PGPSessionKeyEncryptedData;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.api.KeyPassphraseProvider;
import org.bouncycastle.openpgp.api.MissingMessagePassphraseCallback;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.OpenPGPKeyMaterialPool;
import org.bouncycastle.openpgp.api.OpenPGPKeyMaterialProvider;
import org.bouncycastle.openpgp.api.OpenPGPMessageInputStream;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.exception.KeyPassphraseException;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.util.Arrays;

public class OpenPGPMessageProcessor {
    private final OpenPGPImplementation implementation;
    private final Configuration configuration;

    public OpenPGPMessageProcessor() {
        this(OpenPGPImplementation.getInstance());
    }

    public OpenPGPMessageProcessor(OpenPGPImplementation openPGPImplementation) {
        this(openPGPImplementation, openPGPImplementation.policy());
    }

    public OpenPGPMessageProcessor(OpenPGPImplementation openPGPImplementation, OpenPGPPolicy openPGPPolicy) {
        this.implementation = openPGPImplementation;
        this.configuration = new Configuration(openPGPPolicy);
    }

    public OpenPGPMessageProcessor addVerificationCertificate(OpenPGPCertificate openPGPCertificate) {
        this.configuration.certificatePool.addItem(openPGPCertificate);
        return this;
    }

    public OpenPGPMessageProcessor verifyNotAfter(Date date) {
        this.configuration.verifyNotAfter = date;
        return this;
    }

    public OpenPGPMessageProcessor verifyNotBefore(Date date) {
        this.configuration.verifyNotBefore = date;
        return this;
    }

    public OpenPGPMessageProcessor addDecryptionKey(OpenPGPKey openPGPKey) {
        this.configuration.keyPool.addItem(openPGPKey);
        return this;
    }

    public OpenPGPMessageProcessor addDecryptionKey(OpenPGPKey openPGPKey, char[] cArray) {
        this.configuration.keyPool.addItem(openPGPKey);
        this.configuration.keyPassphraseProvider.addPassphrase(openPGPKey, cArray);
        return this;
    }

    public OpenPGPMessageProcessor addDecryptionKeyPassphrase(char[] cArray) {
        this.configuration.keyPassphraseProvider.addPassphrase(cArray);
        return this;
    }

    public OpenPGPMessageProcessor setMissingOpenPGPKeyPassphraseProvider(KeyPassphraseProvider keyPassphraseProvider) {
        this.configuration.keyPassphraseProvider.setMissingPassphraseCallback(keyPassphraseProvider);
        return this;
    }

    public OpenPGPMessageProcessor setMissingOpenPGPCertificateProvider(OpenPGPKeyMaterialProvider.OpenPGPCertificateProvider openPGPCertificateProvider) {
        this.configuration.certificatePool.setMissingItemCallback((OpenPGPKeyMaterialProvider)openPGPCertificateProvider);
        return this;
    }

    public OpenPGPMessageProcessor setMissingOpenPGPKeyProvider(OpenPGPKeyMaterialProvider.OpenPGPKeyProvider openPGPKeyProvider) {
        this.configuration.keyPool.setMissingItemCallback((OpenPGPKeyMaterialProvider)openPGPKeyProvider);
        return this;
    }

    public OpenPGPMessageProcessor addMessagePassphrase(char[] cArray) {
        this.configuration.addMessagePassphrase(cArray);
        return this;
    }

    public OpenPGPMessageProcessor setMissingMessagePassphraseCallback(MissingMessagePassphraseCallback missingMessagePassphraseCallback) {
        this.configuration.missingMessagePassphraseCallback = missingMessagePassphraseCallback;
        return this;
    }

    public OpenPGPMessageProcessor setSessionKey(PGPSessionKey pGPSessionKey) {
        this.configuration.sessionKey = pGPSessionKey;
        return this;
    }

    public OpenPGPMessageInputStream process(InputStream inputStream) throws IOException, PGPException {
        InputStream inputStream2 = PGPUtil.getDecoderStream(inputStream);
        PGPObjectFactory pGPObjectFactory = this.implementation.pgpObjectFactory(inputStream2);
        OpenPGPMessageInputStream openPGPMessageInputStream = new OpenPGPMessageInputStream(pGPObjectFactory, this);
        openPGPMessageInputStream.process();
        return openPGPMessageInputStream;
    }

    Date getVerifyNotBefore() {
        return this.configuration.verifyNotBefore;
    }

    Date getVerifyNotAfter() {
        return this.configuration.verifyNotAfter;
    }

    Decrypted decrypt(PGPEncryptedDataList pGPEncryptedDataList) throws PGPException {
        Object object;
        Object object2;
        Object object3;
        if (this.configuration.sessionKey != null) {
            SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory = this.implementation.sessionKeyDataDecryptorFactory(this.configuration.sessionKey);
            PGPSessionKeyEncryptedData pGPSessionKeyEncryptedData = pGPEncryptedDataList.extractSessionKeyEncryptedData();
            InputStream inputStream = pGPSessionKeyEncryptedData.getDataStream(sessionKeyDataDecryptorFactory);
            IntegrityProtectedInputStream integrityProtectedInputStream = new IntegrityProtectedInputStream(inputStream, pGPSessionKeyEncryptedData);
            return new Decrypted(pGPSessionKeyEncryptedData, this.configuration.sessionKey, integrityProtectedInputStream);
        }
        List<PGPPBEEncryptedData> list = this.skesks(pGPEncryptedDataList);
        List<PGPPublicKeyEncryptedData> list2 = this.pkesks(pGPEncryptedDataList);
        PGPException pGPException = null;
        if (!list.isEmpty() && !this.configuration.messagePassphrases.isEmpty()) {
            for (PGPPBEEncryptedData object4 : list) {
                object3 = this.configuration.messagePassphrases.iterator();
                while (object3.hasNext()) {
                    object2 = (char[])object3.next();
                    try {
                        PBEDataDecryptorFactory pBEDataDecryptorFactory = this.implementation.pbeDataDecryptorFactory((char[])object2);
                        PGPSessionKey pGPSessionKey = object4.getSessionKey(pBEDataDecryptorFactory);
                        SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory = this.implementation.sessionKeyDataDecryptorFactory(pGPSessionKey);
                        PGPSessionKeyEncryptedData pGPSessionKeyEncryptedData = pGPEncryptedDataList.extractSessionKeyEncryptedData();
                        InputStream inputStream = pGPSessionKeyEncryptedData.getDataStream(sessionKeyDataDecryptorFactory);
                        IntegrityProtectedInputStream integrityProtectedInputStream = new IntegrityProtectedInputStream(inputStream, pGPSessionKeyEncryptedData);
                        Decrypted decrypted = new Decrypted(pGPSessionKeyEncryptedData, pGPSessionKey, integrityProtectedInputStream);
                        decrypted.decryptionPassphrase = (char[])object2;
                        return decrypted;
                    }
                    catch (PGPException pGPException2) {
                        this.onException(pGPException2);
                        pGPException = pGPException != null ? pGPException : pGPException2;
                    }
                }
            }
        }
        for (PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData : list2) {
            object3 = pGPPublicKeyEncryptedData.getKeyIdentifier();
            object2 = (OpenPGPKey)this.configuration.keyPool.provide((KeyIdentifier)object3);
            if (object2 == null || (object = ((OpenPGPKey)object2).getSecretKeys().get(object3)) == null) continue;
            try {
                if (!((OpenPGPCertificate.OpenPGPComponentKey)object).isEncryptionKey()) {
                    throw new PGPException("Key is not an encryption key and can therefore not decrypt.");
                }
                char[] cArray = this.configuration.keyPassphraseProvider.getKeyPassword((OpenPGPKey.OpenPGPSecretKey)object);
                PGPKeyPair pGPKeyPair = ((OpenPGPKey.OpenPGPSecretKey)object).unlock(cArray).getKeyPair();
                if (pGPKeyPair == null) {
                    throw new KeyPassphraseException((OpenPGPCertificate.OpenPGPComponentKey)object, (Exception)new PGPException("Cannot unlock secret key."));
                }
                PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory = this.implementation.publicKeyDataDecryptorFactory(pGPKeyPair.getPrivateKey());
                PGPSessionKey pGPSessionKey = pGPPublicKeyEncryptedData.getSessionKey(publicKeyDataDecryptorFactory);
                SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory = this.implementation.sessionKeyDataDecryptorFactory(pGPSessionKey);
                PGPSessionKeyEncryptedData pGPSessionKeyEncryptedData = pGPEncryptedDataList.extractSessionKeyEncryptedData();
                InputStream inputStream = pGPSessionKeyEncryptedData.getDataStream(sessionKeyDataDecryptorFactory);
                IntegrityProtectedInputStream integrityProtectedInputStream = new IntegrityProtectedInputStream(inputStream, pGPSessionKeyEncryptedData);
                Decrypted decrypted = new Decrypted(pGPSessionKeyEncryptedData, pGPSessionKey, integrityProtectedInputStream);
                decrypted.decryptionKey = object;
                return decrypted;
            }
            catch (PGPException pGPException3) {
                this.onException(pGPException3);
            }
        }
        if (!list.isEmpty() && this.configuration.missingMessagePassphraseCallback != null) {
            block9: while (true) {
                char[] cArray = this.configuration.missingMessagePassphraseCallback.getMessagePassphrase();
                Object object5 = cArray;
                if (cArray == null) break;
                Iterator<PGPPBEEncryptedData> iterator = list.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block9;
                    object3 = iterator.next();
                    try {
                        object2 = this.implementation.pbeDataDecryptorFactory((char[])object5);
                        object = ((PGPPBEEncryptedData)object3).getSessionKey((PBEDataDecryptorFactory)object2);
                        SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory = this.implementation.sessionKeyDataDecryptorFactory((PGPSessionKey)object);
                        PGPSessionKeyEncryptedData pGPSessionKeyEncryptedData = pGPEncryptedDataList.extractSessionKeyEncryptedData();
                        InputStream inputStream = pGPSessionKeyEncryptedData.getDataStream(sessionKeyDataDecryptorFactory);
                        IntegrityProtectedInputStream integrityProtectedInputStream = new IntegrityProtectedInputStream(inputStream, pGPSessionKeyEncryptedData);
                        Decrypted decrypted = new Decrypted(pGPSessionKeyEncryptedData, (PGPSessionKey)object, integrityProtectedInputStream);
                        decrypted.decryptionPassphrase = (char[])object5;
                        return decrypted;
                    }
                    catch (PGPException pGPException4) {
                        this.onException(pGPException4);
                        pGPException = pGPException != null ? pGPException : pGPException4;
                        continue;
                    }
                    break;
                }
                break;
            }
            if (pGPException != null) {
                throw pGPException;
            }
        }
        throw new PGPException("No working decryption method found.");
    }

    private List<PGPPBEEncryptedData> skesks(PGPEncryptedDataList pGPEncryptedDataList) {
        ArrayList<PGPPBEEncryptedData> arrayList = new ArrayList<PGPPBEEncryptedData>();
        for (PGPEncryptedData pGPEncryptedData : pGPEncryptedDataList) {
            if (!(pGPEncryptedData instanceof PGPPBEEncryptedData)) continue;
            arrayList.add((PGPPBEEncryptedData)pGPEncryptedData);
        }
        return arrayList;
    }

    private List<PGPPublicKeyEncryptedData> pkesks(PGPEncryptedDataList pGPEncryptedDataList) {
        ArrayList<PGPPublicKeyEncryptedData> arrayList = new ArrayList<PGPPublicKeyEncryptedData>();
        for (PGPEncryptedData pGPEncryptedData : pGPEncryptedDataList) {
            if (!(pGPEncryptedData instanceof PGPPublicKeyEncryptedData)) continue;
            arrayList.add((PGPPublicKeyEncryptedData)pGPEncryptedData);
        }
        return arrayList;
    }

    OpenPGPCertificate provideCertificate(KeyIdentifier keyIdentifier) {
        return this.configuration.certificatePool.provide(keyIdentifier);
    }

    OpenPGPImplementation getImplementation() {
        return this.implementation;
    }

    void onException(PGPException pGPException) {
        if (this.configuration.exceptionCallback != null) {
            this.configuration.exceptionCallback.onException(pGPException);
        }
    }

    public static class Configuration {
        private final OpenPGPPolicy policy;
        private final OpenPGPKeyMaterialPool.OpenPGPCertificatePool certificatePool;
        private final OpenPGPKeyMaterialPool.OpenPGPKeyPool keyPool;
        private final KeyPassphraseProvider.DefaultKeyPassphraseProvider keyPassphraseProvider;
        public final List<char[]> messagePassphrases = new ArrayList<char[]>();
        private MissingMessagePassphraseCallback missingMessagePassphraseCallback;
        private PGPExceptionCallback exceptionCallback = null;
        private PGPSessionKey sessionKey;
        private Date verifyNotAfter = new Date();
        private Date verifyNotBefore = new Date(0L);

        public Configuration(OpenPGPPolicy openPGPPolicy) {
            this.policy = openPGPPolicy;
            this.certificatePool = new OpenPGPKeyMaterialPool.OpenPGPCertificatePool();
            this.keyPool = new OpenPGPKeyMaterialPool.OpenPGPKeyPool();
            this.keyPassphraseProvider = new KeyPassphraseProvider.DefaultKeyPassphraseProvider();
        }

        public Configuration addMessagePassphrase(char[] cArray) {
            boolean bl = false;
            for (char[] cArray2 : this.messagePassphrases) {
                bl |= Arrays.areEqual(cArray2, cArray);
            }
            if (!bl) {
                this.messagePassphrases.add(cArray);
            }
            return this;
        }
    }

    static class Decrypted {
        final InputStream inputStream;
        final PGPSessionKey sessionKey;
        final PGPEncryptedData esk;
        OpenPGPCertificate.OpenPGPComponentKey decryptionKey;
        char[] decryptionPassphrase;

        public Decrypted(PGPEncryptedData pGPEncryptedData, PGPSessionKey pGPSessionKey, InputStream inputStream) {
            this.esk = pGPEncryptedData;
            this.sessionKey = pGPSessionKey;
            this.inputStream = inputStream;
        }
    }

    public static interface PGPExceptionCallback {
        public void onException(PGPException var1);
    }
}

