/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal.variables;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.internal.ConfigComparator;
import com.ibm.ws.config.xml.internal.ConfigRefresher;
import com.ibm.ws.config.xml.internal.variables.ConfigVariableRegistry;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class VariableMonitor
implements com.ibm.ws.kernel.filemonitor.FileMonitor {
    static final TraceComponent tc = Tr.register(VariableMonitor.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private ServiceRegistration<FileMonitor> serviceRegistration;
    private Long monitorInterval;
    private final Collection<String> monitoredDirectories;
    private String monitorType;
    private final BundleContext bundleContext;
    private final ConfigRefresher configRefresher;
    private final ConfigVariableRegistry variableRegistry;
    static final long serialVersionUID = 194690371313122587L;

    public VariableMonitor(BundleContext bc, Long monitorInterval, String fileMonitorType, ConfigRefresher refresher, ConfigVariableRegistry variableRegistry) {
        this.bundleContext = bc;
        ServiceReference sr = bc.getServiceReference(WsLocationAdmin.class);
        this.monitoredDirectories = new ArrayList<String>();
        String fileSystemVariableRoot = ((WsLocationAdmin)bc.getService(sr)).resolveString("${wlp.var.src.dirs}/");
        StringTokenizer st = new StringTokenizer(fileSystemVariableRoot, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String directory = st.nextToken();
            this.monitoredDirectories.add(directory);
        }
        this.monitorInterval = monitorInterval;
        this.monitorType = fileMonitorType;
        this.configRefresher = refresher;
        this.variableRegistry = variableRegistry;
    }

    public void register() {
        Hashtable<String, Object> properties = this.getFileMonitorProperties();
        this.serviceRegistration = this.bundleContext.registerService(FileMonitor.class, (Object)this, properties);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Configuration monitoring is enabled. Monitoring interval is " + this.monitorInterval), (Object[])new Object[0]);
        }
    }

    public void unregister() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Monitoring of VARIABLE_SOURCE_DIRS is disabled.", (Object[])new Object[0]);
        }
    }

    private Hashtable<String, Object> getFileMonitorProperties() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("monitor.files", Collections.EMPTY_LIST);
        properties.put("monitor.directories", this.monitoredDirectories);
        properties.put("monitor.interval", this.monitorInterval);
        properties.put("monitor.type", this.monitorType);
        properties.put("monitor.recurse", true);
        properties.put("monitor.filter", ".*");
        return properties;
    }

    public void update(Long monitorInterval, String fileMonitorType) {
        if (this.monitorInterval.equals(monitorInterval) && this.monitorType.equals(fileMonitorType)) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Updating VariableMonitor with a new monitoring interval: " + monitorInterval + " and type: " + fileMonitorType), (Object[])new Object[0]);
        }
        this.monitorInterval = monitorInterval;
        this.monitorType = fileMonitorType;
        Hashtable<String, Object> properties = this.getFileMonitorProperties();
        this.serviceRegistration.setProperties(properties);
    }

    public void onBaseline(Collection<File> baseline) {
    }

    public void onChange(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
        HashMap<String, ConfigComparator.DeltaType> deltaMap = new HashMap<String, ConfigComparator.DeltaType>();
        this.variableRegistry.removeFileSystemVariableDeletes(deletedFiles, deltaMap);
        this.variableRegistry.addFileSystemVariableCreates(createdFiles, deltaMap);
        this.variableRegistry.modifyFileSystemVariables(modifiedFiles, deltaMap);
        this.configRefresher.variableRefresh(deltaMap);
    }

    public void onChange(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles, String filter) {
        this.onChange(createdFiles, modifiedFiles, deletedFiles);
    }
}

