/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.util;

import com.ibm.ws.common.crypto.CryptoUtils;
import com.ibm.ws.crypto.util.MessageUtils;
import com.ibm.wsspi.security.crypto.KeyStringResolver;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AESKeyManager {
    public static final String NAME_WLP_PASSWORD_ENCRYPTION_KEY = "wlp.password.encryption.key";
    public static final String NAME_WLP_BASE64_AES_ENCRYPTION_KEY = "wlp.aes.encryption.key";
    public static final String PROPERTY_WLP_PASSWORD_ENCRYPTION_KEY = "${wlp.password.encryption.key}";
    public static final String PROPERTY_WLP_BASE64_AES_ENCRYPTION_KEY = "${wlp.aes.encryption.key}";
    private static final AtomicReference<KeyStringResolver> _resolver = new AtomicReference();

    public static Key getKey(KeyVersion version, String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyHolder holder = AESKeyManager.getHolder(version, key);
        return holder.getKey();
    }

    @Deprecated
    public static Key getKey(String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyHolder holder = AESKeyManager.getHolder(KeyVersion.AES_V0, key);
        return holder.getKey();
    }

    private static KeyHolder getHolder(KeyVersion version, String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        char[] keyChars = AESKeyManager.getKeyCharsUsingResolver(version, key);
        return version.get(keyChars);
    }

    public static char[] getKeyCharsUsingResolver(KeyVersion version, String key) {
        char[] keyChars = _resolver.get().getKey(key == null ? version.resolverProperty : key);
        return keyChars;
    }

    public static void setKeyStringResolver(KeyStringResolver resolver) {
        if (resolver == null) {
            resolver = new KeyStringResolver(){

                @Override
                public char[] getKey(String key) {
                    return key.toCharArray();
                }
            };
        }
        _resolver.set(resolver);
    }

    public static IvParameterSpec getIV(KeyVersion version, String cryptoKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return AESKeyManager.getHolder(version, cryptoKey).getIv();
    }

    @Deprecated
    public static IvParameterSpec getIV(String cryptoKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return AESKeyManager.getHolder(KeyVersion.AES_V0, cryptoKey).getIv();
    }

    static {
        AESKeyManager.setKeyStringResolver(null);
    }

    public static enum KeyVersion {
        AES_V0("PBKDF2WithHmacSHA1", 84756, 128, CryptoUtils.AES_V0_SALT, "${wlp.password.encryption.key}"),
        AES_V1("PBKDF2WithHmacSHA512", 210000, 256, CryptoUtils.AES_V1_SALT, "${wlp.password.encryption.key}"),
        AES_V2("AES", 0, 256, null, "${wlp.aes.encryption.key}");

        private final AtomicReference<KeyHolder> _key = new AtomicReference();
        private final String alg;
        private final int iterations;
        public final int keyLength;
        private final byte[] salt;
        private final String resolverProperty;

        private KeyVersion(String alg, int iterations, int keyLength, byte[] salt, String resolverProperty) {
            this.alg = alg;
            this.iterations = iterations;
            this.keyLength = keyLength;
            this.salt = salt;
            this.resolverProperty = resolverProperty;
        }

        private KeyHolder get(char[] keyChars) throws NoSuchAlgorithmException, InvalidKeySpecException {
            KeyHolder holder = this._key.get();
            if (holder == null || !holder.matches(keyChars)) {
                byte[] data = "AES".equals(this.alg) ? this.decodeAesBase64Key(keyChars) : this.buildAesKeyWithPbkdf2(keyChars);
                byte[] iv = Arrays.copyOfRange(data, 0, 16);
                KeyHolder holder2 = new KeyHolder(keyChars, new SecretKeySpec(data, "AES"), new IvParameterSpec(iv));
                this._key.compareAndSet(holder, holder2);
                holder = holder2;
            }
            return holder;
        }

        public byte[] decodeAesBase64Key(char[] keyChars) throws InvalidKeySpecException {
            byte[] data;
            if (keyChars == null || AESKeyManager.PROPERTY_WLP_BASE64_AES_ENCRYPTION_KEY.equals(new String(keyChars))) {
                throw new InvalidKeySpecException(MessageUtils.getMessage("AESKEYMANAGER_BASE64_VARIABLE_NOT_SET", new Object[0]));
            }
            try {
                data = Base64.getDecoder().decode(new String(keyChars));
            }
            catch (IllegalArgumentException iae) {
                throw new InvalidKeySpecException(MessageUtils.getMessage("AESKEYMANAGER_NOT_BASE64_EXCEPTION", new Object[0]), iae);
            }
            int keyBitLength = data.length * 8;
            if (keyBitLength != this.keyLength) {
                throw new InvalidKeySpecException(MessageUtils.getMessage("AESKEYMANAGER_INVALID_KEYLENGTH_EXCEPTION", new Object[0]));
            }
            return data;
        }

        public byte[] buildAesKeyWithPbkdf2(char[] keyChars) throws NoSuchAlgorithmException, InvalidKeySpecException {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(this.alg);
            PBEKeySpec aesKey = new PBEKeySpec(keyChars, this.salt, this.iterations, this.keyLength);
            return keyFactory.generateSecret(aesKey).getEncoded();
        }
    }

    private static class KeyHolder {
        private final char[] keyChars;
        private final Key key;
        private final IvParameterSpec iv;

        public KeyHolder(char[] kc, Key k, IvParameterSpec ivParameterSpec) {
            this.keyChars = kc;
            this.key = k;
            this.iv = ivParameterSpec;
        }

        public boolean matches(char[] k) {
            if (k == this.keyChars) {
                return true;
            }
            return Arrays.equals(k, this.keyChars);
        }

        public Key getKey() {
            return this.key;
        }

        public IvParameterSpec getIv() {
            return this.iv;
        }
    }
}

