/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal;

import com.ibm.websphere.channelfw.CFEndPoint;
import com.ibm.websphere.channelfw.OutboundChannelDefinition;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.io.NotSerializableException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.Map;

public class CFEndPointSerializer {
    private static final TraceComponent tc = Tr.register(CFEndPointSerializer.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");

    private CFEndPointSerializer() {
    }

    private static StringBuilder determineType(String name, Object o) {
        String value = null;
        if (!(o instanceof String || o instanceof StringBuffer || o instanceof CharBuffer || o instanceof Integer || o instanceof Long || o instanceof Byte || o instanceof Double || o instanceof Float || o instanceof Short || o instanceof BigInteger || o instanceof BigDecimal)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Skipping class: " + o.getClass()), (Object[])new Object[0]);
            }
            return null;
        }
        value = o.toString();
        StringBuilder buffer = new StringBuilder(48);
        buffer.append(name);
        buffer.append("type=\"");
        if (o instanceof CharBuffer) {
            buffer.append("java.nio.CharBuffer");
        } else {
            buffer.append(o.getClass().getName());
        }
        buffer.append("\" ");
        buffer.append(name);
        buffer.append("=\"");
        buffer.append(value);
        buffer.append("\"");
        return buffer;
    }

    private static StringBuilder serializeChannel(StringBuilder buffer, OutboundChannelDefinition ocd, int order) throws NotSerializableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Serializing channel: " + order + " " + ocd.getOutboundFactory().getName()), (Object[])new Object[0]);
        }
        buffer.append("   <channel order=\"");
        buffer.append(order);
        buffer.append("\" factory=\"");
        buffer.append(ocd.getOutboundFactory().getName());
        buffer.append("\">\n");
        Map<Object, Object> props = ocd.getOutboundChannelProperties();
        if (null != props) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                StringBuilder vBuff;
                if (null == entry.getValue()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Property value [" + entry.getKey() + "] is null, " + ocd.toString()), (Object[])new Object[0]);
                    }
                    throw new NotSerializableException("Property value for [" + entry.getKey() + "] is null");
                }
                StringBuilder kBuff = CFEndPointSerializer.determineType("key", entry.getKey());
                if (null == kBuff || null == (vBuff = CFEndPointSerializer.determineType("value", entry.getValue()))) continue;
                buffer.append("      <property ");
                buffer.append((CharSequence)kBuff);
                buffer.append(" ");
                buffer.append((CharSequence)vBuff);
                buffer.append("/>\n");
            }
        }
        buffer.append("   </channel>\n");
        return buffer;
    }

    public static String serialize(CFEndPoint point) throws NotSerializableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serialize", (Object[])new Object[0]);
        }
        if (null == point) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Null CFEndPoint input for serialization", (Object[])new Object[0]);
            }
            throw new NotSerializableException("Null input");
        }
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Serializing endpoint: " + point.getName()), (Object[])new Object[0]);
        }
        buffer.append("<cfendpoint name=\"");
        buffer.append(point.getName());
        buffer.append("\" host=\"");
        buffer.append(point.getAddress().getCanonicalHostName());
        buffer.append("\" port=\"");
        buffer.append(point.getPort());
        buffer.append("\" local=\"");
        buffer.append(point.isLocal());
        buffer.append("\" ssl=\"");
        buffer.append(point.isSSLEnabled());
        buffer.append("\">\n");
        int i = 0;
        for (OutboundChannelDefinition def : point.getOutboundChannelDefs()) {
            buffer = CFEndPointSerializer.serializeChannel(buffer, def, i++);
        }
        buffer.append("</cfendpoint>");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Serialized string: \n" + buffer.toString()), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serialize");
        }
        return buffer.toString();
    }
}

