/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.trace;

import io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpGrpcSpanExporter
implements SpanExporter {
    private final GrpcExporterBuilder<TraceRequestMarshaler> builder;
    private final GrpcExporter<TraceRequestMarshaler> delegate;

    public static OtlpGrpcSpanExporter getDefault() {
        return OtlpGrpcSpanExporter.builder().build();
    }

    public static OtlpGrpcSpanExporterBuilder builder() {
        return new OtlpGrpcSpanExporterBuilder();
    }

    OtlpGrpcSpanExporter(GrpcExporterBuilder<TraceRequestMarshaler> builder, GrpcExporter<TraceRequestMarshaler> delegate) {
        this.builder = builder;
        this.delegate = delegate;
    }

    public OtlpGrpcSpanExporterBuilder toBuilder() {
        return new OtlpGrpcSpanExporterBuilder(this.builder.copy());
    }

    @Override
    public CompletableResultCode export(Collection<SpanData> spans) {
        TraceRequestMarshaler request = TraceRequestMarshaler.create(spans);
        return this.delegate.export(request, spans.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        return "OtlpGrpcSpanExporter{" + this.builder.toString(false) + "}";
    }
}

