/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg.sig;

import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.util.Integers;

public class KeyFlags
extends SignatureSubpacket {
    public static final int CERTIFY_OTHER = 1;
    public static final int SIGN_DATA = 2;
    public static final int ENCRYPT_COMMS = 4;
    public static final int ENCRYPT_STORAGE = 8;
    public static final int SPLIT = 16;
    public static final int AUTHENTICATION = 32;
    public static final int SHARED = 128;

    private static int dataToFlags(byte[] byArray) {
        int n = 0;
        int n2 = Math.min(4, byArray.length);
        for (int i = 0; i < n2; ++i) {
            n |= (byArray[i] & 0xFF) << i * 8;
        }
        return n;
    }

    private static byte[] flagsToData(int n) {
        int n2 = 32 - Integers.numberOfLeadingZeros(n);
        int n3 = (n2 + 7) / 8;
        byte[] byArray = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            byArray[i] = (byte)(n >> i * 8);
        }
        return byArray;
    }

    public KeyFlags(boolean bl, boolean bl2, byte[] byArray) {
        super(27, bl, bl2, byArray);
    }

    public KeyFlags(boolean bl, int n) {
        super(27, bl, false, KeyFlags.flagsToData(n));
    }

    public int getFlags() {
        return KeyFlags.dataToFlags(this.data);
    }
}

