/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection.jdk8;

import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class IndirectSet<E>
extends org.eclipse.persistence.indirection.IndirectSet<E> {
    public IndirectSet() {
    }

    public IndirectSet(int initialCapacity) {
        super(initialCapacity);
    }

    public IndirectSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public IndirectSet(Collection<? extends E> c) {
        super(c);
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.getDelegate().spliterator();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.getDelegate().parallelStream();
    }

    @Override
    public Stream<E> stream() {
        return this.getDelegate().stream();
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            boolean hasChanged = false;
            Iterator<E> objects = this.iterator();
            while (objects.hasNext()) {
                if (!filter.test(objects.next())) continue;
                objects.remove();
                hasChanged |= true;
            }
            return hasChanged;
        }
        return this.getDelegate().removeIf(filter);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.getDelegate().forEach(action);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<E> delegateIterator;
            E currentObject;
            {
                this.delegateIterator = IndirectSet.this.getDelegate().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public E next() {
                this.currentObject = this.delegateIterator.next();
                return this.currentObject;
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                IndirectSet.this.raiseRemoveChangeEvent(this.currentObject);
            }

            @Override
            public void forEachRemaining(Consumer<? super E> action) {
                this.delegateIterator.forEachRemaining(action);
            }
        };
    }
}

