/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Response;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.http.HTTPBinding;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.saaj.SAAJFactoryResolver;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.EndpointReferenceBuilder;
import org.apache.cxf.jaxws.JaxwsClientCallback;
import org.apache.cxf.jaxws.JaxwsResponseCallback;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class JaxWsClientProxy
extends ClientProxy
implements BindingProvider {
    public static final String THREAD_LOCAL_REQUEST_CONTEXT = "thread.local.request.context";
    private static final Logger LOG = LogUtils.getL7dLogger(JaxWsClientProxy.class);
    private Binding binding;
    private EndpointReferenceBuilder builder;
    static final long serialVersionUID = -5508185975443988999L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JaxWsClientProxy(Client c, Binding b) {
        super(c);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JaxWsClientProxy", "<init>", new Object[]{c, b});
        }
        this.binding = b;
        this.setupEndpointAddressContext(this.getClient().getEndpoint());
        this.builder = new EndpointReferenceBuilder((JaxWsEndpointImpl)this.getClient().getEndpoint());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void close() throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JaxWsClientProxy", "close", new Object[0]);
        }
        super.close();
        this.binding = null;
        this.builder = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "close");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setupEndpointAddressContext(Endpoint endpoint) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JaxWsClientProxy", "setupEndpointAddressContext", new Object[]{endpoint});
        }
        if (null != endpoint && null != endpoint.getEndpointInfo().getAddress()) {
            this.getRequestContext().put("javax.xml.ws.service.endpoint.address", endpoint.getEndpointInfo().getAddress());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "setupEndpointAddressContext");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object[] params;
        MethodDispatcher dispatcher;
        String address;
        Endpoint endpoint;
        boolean isFinestEnabled;
        block20: {
            Object object;
            block21: {
                block18: {
                    Object object2;
                    block19: {
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            LOG.entering("org.apache.cxf.jaxws.JaxWsClientProxy", "invoke", new Object[]{proxy, method, args});
                        }
                        isFinestEnabled = LOG.isLoggable(Level.FINEST);
                        if (this.client == null) {
                            throw new IllegalStateException("The client has been closed.");
                        }
                        endpoint = this.getClient().getEndpoint();
                        address = endpoint.getEndpointInfo().getAddress();
                        dispatcher = (MethodDispatcher)endpoint.getService().get((Object)MethodDispatcher.class.getName());
                        params = args;
                        if (null == params) {
                            params = new Object[]{};
                        }
                        try {
                            if (!method.getDeclaringClass().equals(BindingProvider.class) && !method.getDeclaringClass().equals(Object.class) && !method.getDeclaringClass().equals(Closeable.class) && !method.getDeclaringClass().equals(AutoCloseable.class)) break block18;
                            object2 = method.invoke((Object)this, params);
                            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block19;
                        }
                        catch (InvocationTargetException e) {
                            throw e.getCause();
                        }
                        object2 = object2;
                        LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "invoke", object2);
                    }
                    return object2;
                }
                if (!method.getDeclaringClass().isInstance(this.client)) break block20;
                object = method.invoke((Object)this.client, params);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block21;
                object = object;
                LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "invoke", object);
            }
            return object;
        }
        BindingOperationInfo oi = dispatcher.getBindingOperation(method, endpoint);
        if (oi == null) {
            Message msg = new Message("NO_BINDING_OPERATION_INFO", LOG, new Object[]{method.getName()});
            throw new WebServiceException(msg.toString());
        }
        this.client.getRequestContext().put(Method.class.getName(), method);
        boolean isAsync = this.isAsync(method);
        Object result = null;
        try {
            result = isAsync ? this.invokeAsync(method, oi, params) : this.invokeSync(method, oi, params);
        }
        catch (WebServiceException wex) {
            throw wex;
        }
        catch (Exception ex) {
            throw this.mapException(method, oi, ex);
        }
        finally {
            if (this.addressChanged(address)) {
                this.setupEndpointAddressContext(this.getClient().getEndpoint());
                if (isFinestEnabled) {
                    LOG.finest("Endpoint address has changed, Context is updated with the new address: " + this.getRequestContext().get("javax.xml.ws.service.endpoint.address"));
                }
            }
        }
        Map respContext = this.client.getResponseContext();
        Map scopes = CastUtils.cast((Map)((Map)respContext.get(WrappedMessageContext.SCOPES)));
        if (scopes != null) {
            for (Map.Entry scope : scopes.entrySet()) {
                if (scope.getValue() != MessageContext.Scope.HANDLER) continue;
                respContext.remove(scope.getKey());
            }
        }
        Object object = this.adjustObject(result);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "invoke", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    Exception mapException(Method method, BindingOperationInfo boi, Exception ex) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JaxWsClientProxy", "mapException", new Object[]{method, boi, ex});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        if (method != null) {
            for (Class<?> excls : method.getExceptionTypes()) {
                if (!excls.isInstance(ex)) continue;
                if (isFinestEnabled) {
                    LOG.finest("Exception: " + excls + " is instance of " + ex + ". Returning.");
                }
                Exception exception = ex;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    exception = exception;
                    LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "mapException", exception);
                }
                return exception;
            }
        } else if (boi != null) {
            for (BindingFaultInfo fi : boi.getFaults()) {
                Class c = (Class)fi.getFaultInfo().getProperty(Class.class.getName(), Class.class);
                if (c == null || !c.isInstance(ex)) continue;
                if (isFinestEnabled) {
                    LOG.finest("Exception class: " + c + " is instance of " + ex + ". Returning.");
                }
                Exception exception = ex;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    exception = exception;
                    LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "mapException", exception);
                }
                return exception;
            }
            if (ex instanceof IOException) {
                if (isFinestEnabled) {
                    LOG.finest("Exception: " + ex + " is instance of IOException. Returning.");
                }
                Exception exception = ex;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    exception = exception;
                    LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "mapException", exception);
                }
                return exception;
            }
        }
        if (ex instanceof Fault && ex.getCause() instanceof IOException) {
            WebServiceException webServiceException = new WebServiceException(ex.getMessage(), ex.getCause());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                webServiceException = webServiceException;
                LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "mapException", (Object)webServiceException);
            }
            return webServiceException;
        }
        if (this.getBinding() instanceof HTTPBinding) {
            HTTPException exception = new HTTPException(500);
            exception.initCause((Throwable)ex);
            if (isFinestEnabled) {
                LOG.finest("Binding is instance of HTTPBinding. HTTPException is initialized with exception cause: " + ex);
            }
            HTTPException hTTPException = exception;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                hTTPException = hTTPException;
                LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "mapException", hTTPException);
            }
            return hTTPException;
        }
        if (this.getBinding() instanceof SOAPBinding) {
            SOAPFaultException sOAPFaultException;
            block27: {
                try {
                    SOAPFault soapFault = JaxWsClientProxy.createSoapFault((SOAPBinding)this.getBinding(), ex);
                    if (soapFault == null) {
                        throw new WebServiceException((Throwable)ex);
                    }
                    SOAPFaultException exception = new SOAPFaultException(soapFault);
                    if (ex instanceof Fault && ex.getCause() != null) {
                        exception.initCause(ex.getCause());
                    } else {
                        exception.initCause((Throwable)ex);
                    }
                    if (isFinestEnabled) {
                        LOG.finest("Binding is instance of SOAPBinding. SOAPBinding is initialized with exception cause: " + ex);
                    }
                    sOAPFaultException = exception;
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block27;
                }
                catch (SOAPException e) {
                    WebServiceException webServiceException = new WebServiceException((Throwable)ex);
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        webServiceException = webServiceException;
                        LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "mapException", (Object)webServiceException);
                    }
                    return webServiceException;
                }
                sOAPFaultException = sOAPFaultException;
                LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "mapException", sOAPFaultException);
            }
            return sOAPFaultException;
        }
        WebServiceException webServiceException = new WebServiceException((Throwable)ex);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            webServiceException = webServiceException;
            LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "mapException", (Object)webServiceException);
        }
        return webServiceException;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    boolean isAsync(Method m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JaxWsClientProxy", "isAsync", new Object[]{m});
        }
        boolean bl = m.getName().endsWith("Async") && (Future.class.equals(m.getReturnType()) || Response.class.equals(m.getReturnType()));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "isAsync", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static SOAPFault createSoapFault(SOAPBinding binding, Exception ex) throws SOAPException {
        SOAPFault soapFault;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JaxWsClientProxy", "createSoapFault", new Object[]{binding, ex});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        try {
            soapFault = binding.getSOAPFactory().createFault();
            if (isFinestEnabled) {
                LOG.finest("SOAPFault is created trough SOAPBinding SOAPFactory: " + soapFault.getFaultString());
            }
        }
        catch (Throwable t) {
            if (isFinestEnabled) {
                LOG.finest("SOAPFault failed to be created using SOAPFactory createFault method, attempting SAAJ 1.2 method to create SOAPFault");
            }
            try {
                soapFault = binding.getMessageFactory().createMessage().getSOAPPart().getEnvelope().getBody().addFault();
                if (isFinestEnabled) {
                    LOG.finest("SOAPFault created using saaj 1.2 method:" + soapFault);
                }
            }
            catch (Throwable t2) {
                if (isFinestEnabled) {
                    LOG.finest("Failed to create the SOAPFault. Returning.");
                }
                SOAPFault sOAPFault = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    sOAPFault = sOAPFault;
                    LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "createSoapFault", sOAPFault);
                }
                return sOAPFault;
            }
        }
        if (ex instanceof SoapFault) {
            block31: {
                if (!soapFault.getNamespaceURI().equals(((SoapFault)ex).getFaultCode().getNamespaceURI()) && "http://schemas.xmlsoap.org/soap/envelope/".equals(((SoapFault)ex).getFaultCode().getNamespaceURI())) {
                    try {
                        soapFault = SAAJFactoryResolver.createSOAPFactory(null).createFault();
                        if (isFinestEnabled) {
                            LOG.finest("SoapFault created with SAAJFactoryResolver: " + soapFault.getFaultString());
                        }
                    }
                    catch (Throwable t) {
                        if (!isFinestEnabled) break block31;
                        LOG.finest("SOAPFault failed to be created with throwable: " + t.getMessage());
                    }
                }
            }
            boolean isSoap11 = "http://schemas.xmlsoap.org/soap/envelope/".equals(soapFault.getNamespaceURI());
            if (isFinestEnabled) {
                LOG.finest("Is this SOAP 11: " + isSoap11);
            }
            if (StringUtils.isEmpty((String)((SoapFault)ex).getLang())) {
                if (isFinestEnabled) {
                    LOG.finest("Any specific language is not specified in SOAPFault. Fault String will be set with default.");
                }
                soapFault.setFaultString(((SoapFault)ex).getReason());
            } else {
                if (isFinestEnabled) {
                    LOG.finest("A language is specified in SOAPFault. Fault String willl be set with language: " + ((SoapFault)ex).getLang());
                }
                soapFault.setFaultString(((SoapFault)ex).getReason(), JaxWsClientProxy.stringToLocale(((SoapFault)ex).getLang()));
            }
            SAAJUtils.setFaultCode((SOAPFault)soapFault, (QName)((SoapFault)ex).getFaultCode());
            String role = ((SoapFault)ex).getRole();
            if (role != null) {
                soapFault.setFaultActor(role);
            }
            if (((SoapFault)ex).getSubCodes() != null && !isSoap11) {
                ArrayList<QName> lsc = new ArrayList<QName>();
                for (QName fsc : ((SoapFault)ex).getSubCodes()) {
                    soapFault.appendFaultSubcode(fsc);
                    lsc.add(fsc);
                }
                if (isFinestEnabled) {
                    LOG.finest("FaultSubcodes that are added to SoapFault: " + lsc);
                }
            }
            if (((SoapFault)ex).hasDetails()) {
                Node nd = soapFault.getOwnerDocument().importNode(((SoapFault)ex).getDetail(), true);
                nd = nd.getFirstChild();
                soapFault.addDetail();
                ArrayList<Node> ln = new ArrayList<Node>();
                while (nd != null) {
                    Node next = nd.getNextSibling();
                    soapFault.getDetail().appendChild(nd);
                    ln.add(nd);
                    nd = next;
                }
                if (isFinestEnabled) {
                    LOG.finest("Nodes that are added to Soap fault details: " + ln);
                }
            }
        } else {
            String msg = ex.getMessage();
            if (msg != null) {
                soapFault.setFaultString(msg);
                if (isFinestEnabled) {
                    LOG.finest("Exception is not an instance of SoapFault. Fault string set to: " + msg);
                }
            }
        }
        SOAPFault sOAPFault = soapFault;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            sOAPFault = sOAPFault;
            LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "createSoapFault", sOAPFault);
        }
        return sOAPFault;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Locale stringToLocale(String locale) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JaxWsClientProxy", "stringToLocale", new Object[]{locale});
        }
        String[] parts = locale.split("-", 0);
        if (parts.length == 1) {
            Locale locale2 = new Locale(parts[0]);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                locale2 = locale2;
                LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "stringToLocale", locale2);
            }
            return locale2;
        }
        if (parts.length == 2) {
            Locale locale3 = new Locale(parts[0], parts[1]);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                locale3 = locale3;
                LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "stringToLocale", locale3);
            }
            return locale3;
        }
        Locale locale4 = new Locale(parts[0], parts[1], parts[2]);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            locale4 = locale4;
            LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "stringToLocale", locale4);
        }
        return locale4;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean addressChanged(String address) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JaxWsClientProxy", "addressChanged", new Object[]{address});
        }
        boolean bl = address != null && this.getClient().getEndpoint().getEndpointInfo() != null && !address.equals(this.getClient().getEndpoint().getEndpointInfo().getAddress());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "addressChanged", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Object invokeAsync(Method method, final BindingOperationInfo oi, Object[] params) throws Exception {
        AsyncHandler handler;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JaxWsClientProxy", "invokeAsync", new Object[]{method, oi, params});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        this.client.setExecutor(this.getClient().getEndpoint().getExecutor());
        if (params.length > 0 && params[params.length - 1] instanceof AsyncHandler) {
            handler = (AsyncHandler)params[params.length - 1];
            Object[] newParams = new Object[params.length - 1];
            System.arraycopy(params, 0, newParams, 0, newParams.length);
            params = newParams;
            if (isFinestEnabled) {
                LOG.finest("AsyncHandler: " + handler + " and parameters: " + params + " provided in parameters will be used for invocation in invokeAsync mehod.");
            }
        } else {
            handler = null;
            if (isFinestEnabled) {
                LOG.finest("AsyncHandler is not provided in parameters. It's set to null.");
            }
        }
        JaxwsClientCallback<Object> callback = new JaxwsClientCallback<Object>(handler, (Object)this){
            static final long serialVersionUID = -2869280863648831371L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            protected Throwable mapThrowable(Throwable t) {
                if (t instanceof Exception) {
                    t = JaxWsClientProxy.this.mapException(null, oi, (Exception)t);
                }
                return t;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxws.JaxWsClientProxy$1", 1.class, null, null);
            }
        };
        JaxwsResponseCallback ret = new JaxwsResponseCallback(callback);
        this.client.invoke((ClientCallback)callback, oi, params);
        JaxwsResponseCallback jaxwsResponseCallback = ret;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            jaxwsResponseCallback = jaxwsResponseCallback;
            LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "invokeAsync", jaxwsResponseCallback);
        }
        return jaxwsResponseCallback;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Object> getRequestContext() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JaxWsClientProxy", "getRequestContext", new Object[0]);
        }
        if (this.client == null) {
            throw new IllegalStateException("The client has been closed.");
        }
        WrappedMessageContext wrappedMessageContext = new WrappedMessageContext(this.getClient().getRequestContext(), null, MessageContext.Scope.APPLICATION);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            wrappedMessageContext = wrappedMessageContext;
            LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "getRequestContext", wrappedMessageContext);
        }
        return wrappedMessageContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Object> getResponseContext() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JaxWsClientProxy", "getResponseContext", new Object[0]);
        }
        if (this.client == null) {
            throw new IllegalStateException("The client has been closed.");
        }
        WrappedMessageContext wrappedMessageContext = new WrappedMessageContext(this.getClient().getResponseContext(), null, MessageContext.Scope.APPLICATION);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            wrappedMessageContext = wrappedMessageContext;
            LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "getResponseContext", wrappedMessageContext);
        }
        return wrappedMessageContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Binding getBinding() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JaxWsClientProxy", "getBinding", new Object[0]);
        }
        if (this.client == null) {
            throw new IllegalStateException("The client has been closed.");
        }
        Binding binding = this.binding;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            binding = binding;
            LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "getBinding", binding);
        }
        return binding;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EndpointReference getEndpointReference() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JaxWsClientProxy", "getEndpointReference", new Object[0]);
        }
        if (this.client == null) {
            throw new IllegalStateException("The client has been closed.");
        }
        EndpointReference endpointReference = this.builder.getEndpointReference();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            endpointReference = endpointReference;
            LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "getEndpointReference", endpointReference);
        }
        return endpointReference;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JaxWsClientProxy", "getEndpointReference", new Object[]{clazz});
        }
        if (this.client == null) {
            throw new IllegalStateException("The client has been closed.");
        }
        T t = this.builder.getEndpointReference(clazz);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            t = t;
            LOG.exiting("org.apache.cxf.jaxws.JaxWsClientProxy", "getEndpointReference", t);
        }
        return t;
    }
}

