/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager.utils;

import com.ibm.ws.objectManager.utils.FileLock;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import com.ibm.ws.objectManager.utils.Utils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public class FileLockImpl
extends FileLock {
    private static final Class cclass = FileLockImpl.class;
    private static Trace trace = Utils.traceFactory.getTrace(cclass, "ObjectManagerUtils");
    private FileChannel fileChannel;
    private java.nio.channels.FileLock fileLock = null;

    public FileLockImpl(RandomAccessFile file, String fileName) throws IOException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{file, fileName});
        }
        this.fileChannel = file.getChannel();
        this.fileLock = this.fileChannel.tryLock();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    @Override
    public boolean tryLock() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "tryLock");
        }
        boolean isLocked = true;
        if (this.fileLock == null) {
            isLocked = false;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "tryLock", "returns isLocked=" + isLocked + "(bloolean)");
        }
        return isLocked;
    }

    @Override
    public final void release() throws IOException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "release");
        }
        if (this.fileLock != null) {
            this.fileLock.release();
        }
        this.fileLock = null;
        if (this.fileChannel != null) {
            this.fileChannel.close();
        }
        this.fileChannel = null;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "release");
        }
    }
}

