/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils.linkedlist;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.utils.linkedlist.SimpleEntry;
import com.ibm.ws.sib.utils.ras.SibTr;

public class SimpleLinkedList {
    protected SimpleEntry first = null;
    protected SimpleEntry last = null;
    private static TraceComponent tc = SibTr.register(SimpleLinkedList.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public void put(SimpleEntry simpleEntry) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"put", (Object)simpleEntry);
        }
        simpleEntry.previous = this.last;
        simpleEntry.list = this;
        if (this.last != null) {
            this.last.next = simpleEntry;
        } else {
            this.first = simpleEntry;
        }
        this.last = simpleEntry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"put", (Object)this.printList());
        }
    }

    public SimpleEntry getFirst() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getFirst");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getFirst", (Object)new Object[]{this.first, this.printList()});
        }
        return this.first;
    }

    protected String printList() {
        String output = "[";
        SimpleEntry pointer = this.first;
        for (int counter = 0; pointer != null && counter < 3; ++counter) {
            output = output + "@" + Integer.toHexString(pointer.hashCode());
            pointer = pointer.next;
            if (pointer == null) continue;
            output = output + ", ";
        }
        output = pointer != null ? output + "..., @" + Integer.toHexString(this.last.hashCode()) + "]" : output + "]";
        return output;
    }
}

