/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;

public enum PrivilegedActions {

    public static final PrivilegedAction<Properties> GET_SYSPROPS = System::getProperties;
    public static final PrivilegedAction<Map<Object, Object>> GET_SYSPROPS_OR_EMPTY_MAP = () -> {
        try {
            return System.getProperties();
        }
        catch (SecurityException swallowed) {
            return Collections.emptyMap();
        }
    };
    public static final PrivilegedAction<ClassLoader> GET_CONTEXT_CLASS_LOADER = () -> Thread.currentThread().getContextClassLoader();

    public static PrivilegedAction<String> getSysProp(String key) {
        return () -> System.getProperty(key);
    }

    public static PrivilegedAction<String> getSysProp(String key, String defaultValue) {
        return () -> System.getProperty(key, defaultValue);
    }

    public static PrivilegedAction<ClassLoader> getClassLoader(Class<?> clz) {
        return clz::getClassLoader;
    }

    public static <T> PrivilegedExceptionAction<Constructor<T>> getNoArgConstructor(Class<T> clz) {
        return () -> clz.getDeclaredConstructor(new Class[0]);
    }

    public static PrivilegedExceptionAction<Method> getMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        return () -> type.getMethod(name, parameterTypes);
    }

    public static PrivilegedExceptionAction<Method> getDeclaredMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        return () -> type.getDeclaredMethod(name, parameterTypes);
    }

    public static <T> PrivilegedAction<T> action(PrivilegedAction<T> action) {
        return action;
    }
}

