/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.lra.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.providers.api.JaxRsProviderRegister;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.narayana.lra.client.NarayanaLRAClient;
import io.narayana.lra.filter.ClientLRARequestFilter;
import io.narayana.lra.filter.ClientLRAResponseFilter;
import io.narayana.lra.filter.ServerLRAFilter;
import io.openliberty.microprofile.lra.internal.LraConfig;
import io.openliberty.microprofile.lra.internal.LraException;
import io.openliberty.microprofile.lra.internal.LraRuntimeException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.CDI;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={JaxRsProviderRegister.class})
public class LraFilterComponent
implements JaxRsProviderRegister {
    private static final TraceComponent tc = Tr.register(LraFilterComponent.class, (String)"LRA", (String)"io.openliberty.microprofile.lra.internal.resources.Lra");
    @Reference
    private LraConfig config;
    static final long serialVersionUID = 6573867610929171540L;

    /*
     * WARNING - void declaration
     */
    @Activate
    protected void activate(Map<String, Object> properties) throws LraException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"LraFilterComponent activated", (Object[])new Object[]{properties});
        }
        String coordString = "http://" + this.config.getHost() + ":" + this.config.getPort() + "/" + this.config.getPath();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Attempting to contact coordinator at " + coordString), (Object[])new Object[0]);
        }
        try {
            URI coord = new URI(coordString);
            NarayanaLRAClient.setDefaultCoordinatorEndpoint((URI)coord);
        }
        catch (URISyntaxException coord) {
            void e;
            FFDCFilter.processException((Throwable)coord, (String)"io.openliberty.microprofile.lra.internal.LraFilterComponent", (String)"69", (Object)this, (Object[])new Object[]{properties});
            throw new LraException(Tr.formatMessage((TraceComponent)tc, (String)"LRA_INVALID_COORDINATOR_URI.CWMRX5000E", (Object[])new Object[0]), (Exception)e);
        }
    }

    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("SampleComponent deactivated, reason=" + reason), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void installProvider(boolean clientSide, List<Object> providers, Set<String> features) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Registering LRA filters", (Object[])new Object[0]);
        }
        if (clientSide) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Registering client side filters", (Object[])new Object[0]);
            }
            ClientLRARequestFilter requestFilter = new ClientLRARequestFilter();
            providers.add(requestFilter);
            ClientLRAResponseFilter responseFilter = new ClientLRAResponseFilter();
            providers.add(responseFilter);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Registering serverside side filters", (Object[])new Object[0]);
            }
            try {
                ServerLRAFilter beanInstance = (ServerLRAFilter)CDI.current().select(ServerLRAFilter.class, new Annotation[0]).get();
                providers.add(beanInstance);
            }
            catch (Exception beanInstance) {
                void e;
                FFDCFilter.processException((Throwable)beanInstance, (String)"io.openliberty.microprofile.lra.internal.LraFilterComponent", (String)"112", (Object)this, (Object[])new Object[]{clientSide, providers, features});
                throw new LraRuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"LRA_CANT_REGISTER_FILTERS.CWMRX5001E", (Object[])new Object[]{e}), (Exception)e);
            }
        }
    }
}

