/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.impl.KnownSamlUrl;
import java.io.IOException;
import java.util.regex.Matcher;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RequestFilter
implements Filter {
    private static TraceComponent tc = Tr.register(RequestFilter.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlWab20Messages");
    public static final String PATH_SAML_METADATA = "samlmetadata";
    public static final String PATH_ACS = "acs";
    public static final String PATH_SAML_LOGOUT = "logout";
    public static final String PATH_SAML_SLO = "slo";
    static final long serialVersionUID = 4154405854426165129L;

    public Constants.SamlSsoVersion getSamlVersion() {
        return Constants.SamlSsoVersion.SAMLSSO20;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        Matcher matcher = RequestFilter.endpointRequest(request);
        if (matcher != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("doFiler response.isCommitted():" + response.isCommitted()), (Object[])new Object[0]);
            }
            if (!response.isCommitted()) {
                this.setEndpointRequest(request, response, chain, matcher);
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"SAML20_INVALID_ACS_URL", (Object[])new Object[]{request.getPathInfo()});
            String message = Tr.formatMessage((TraceComponent)tc, (String)"SAML20_AUTHENTICATION_FAIL", (Object[])new Object[0]);
            response.sendError(404, message);
        }
    }

    public void setEndpointRequest(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Matcher matcher) throws IOException, ServletException {
        SsoRequest samlRequest = new SsoRequest(this.getProviderNameFromUrl(matcher), this.getEndpointTypeFromUrl(matcher), request, this.getSamlVersion());
        request.setAttribute("Saml20Request", (Object)samlRequest);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected String getProviderNameFromUrl(Matcher m) {
        String componentId = m.group(1);
        return componentId;
    }

    protected Constants.EndpointType getEndpointTypeFromUrl(Matcher m) {
        Constants.EndpointType type = RequestFilter.getType(m.group(2));
        return type;
    }

    public void init(FilterConfig fConfig) throws ServletException {
    }

    public static Matcher endpointRequest(HttpServletRequest request) {
        Matcher m;
        String path = request.getPathInfo();
        if (path != null && (m = KnownSamlUrl.matchKnownSamlUrl((String)path)).matches()) {
            return m;
        }
        return null;
    }

    private static Constants.EndpointType getType(String pathType) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("path type is " + pathType), (Object[])new Object[0]);
        }
        if (pathType.equals(PATH_SAML_METADATA)) {
            return Constants.EndpointType.SAMLMETADATA;
        }
        if (pathType.startsWith(PATH_ACS)) {
            return Constants.EndpointType.ACS;
        }
        if (pathType.equals(PATH_SAML_SLO)) {
            return Constants.EndpointType.SLO;
        }
        if (pathType.equals(PATH_SAML_LOGOUT)) {
            return Constants.EndpointType.LOGOUT;
        }
        return Constants.EndpointType.valueOf((String)pathType);
    }
}

