/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.ws.impl;

import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.RemotablePartitionEntity;
import com.ibm.jbatch.container.persistence.jpa.RemotablePartitionKey;
import com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntity;
import com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.persistence.PersistenceServiceUnit;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.StepExecution;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class WSStartupRecoveryServiceImpl {
    private static final Logger logger = Logger.getLogger(WSStartupRecoveryServiceImpl.class.getName(), "com.ibm.jbatch.container.internal.resources.JBatchMessages");
    private JPAPersistenceManagerImpl persistenceManagerService;
    private PersistenceServiceUnit psu;
    static final long serialVersionUID = -9093469207262562510L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSStartupRecoveryServiceImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSStartupRecoveryServiceImpl", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSStartupRecoveryServiceImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSStartupRecoveryServiceImpl setIPersistenceManagerService(JPAPersistenceManagerImpl pms) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSStartupRecoveryServiceImpl", "setIPersistenceManagerService", new Object[]{pms});
        }
        this.persistenceManagerService = pms;
        WSStartupRecoveryServiceImpl wSStartupRecoveryServiceImpl = this;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSStartupRecoveryServiceImpl = wSStartupRecoveryServiceImpl;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSStartupRecoveryServiceImpl", "setIPersistenceManagerService", wSStartupRecoveryServiceImpl);
        }
        return wSStartupRecoveryServiceImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSStartupRecoveryServiceImpl setPersistenceServiceUnit(PersistenceServiceUnit psu) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSStartupRecoveryServiceImpl", "setPersistenceServiceUnit", new Object[]{psu});
        }
        this.psu = psu;
        WSStartupRecoveryServiceImpl wSStartupRecoveryServiceImpl = this;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSStartupRecoveryServiceImpl = wSStartupRecoveryServiceImpl;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSStartupRecoveryServiceImpl", "setPersistenceServiceUnit", wSStartupRecoveryServiceImpl);
        }
        return wSStartupRecoveryServiceImpl;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSStartupRecoveryServiceImpl recoverLocalPartitionsInInflightStates() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSStartupRecoveryServiceImpl", "recoverLocalPartitionsInInflightStates", new Object[0]);
        }
        String methodName = "recoverLocalPartitionsInInflightStates";
        try {
            List<RemotablePartitionEntity> remotablePartitions = this.persistenceManagerService.getRemotablePartitionsRunningLocalToServer(this.psu);
            for (RemotablePartitionEntity partition : remotablePartitions) {
                StepThreadExecutionEntity stepExecution = partition.getStepExecution();
                RemotablePartitionKey key = new RemotablePartitionKey(stepExecution);
                String newExitStatus = stepExecution.getExitStatus();
                if (newExitStatus == null) {
                    newExitStatus = BatchStatus.FAILED.name();
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(methodName + ": marking [partition = " + key + ",old batchStatus=" + stepExecution.getBatchStatus().name() + " to new batchStatus=FAILED, new exitStatus=" + newExitStatus + "]");
                }
                Date markFailedTime = new Date();
                try {
                    this.persistenceManagerService.updateStepExecutionOnRecovery(this.psu, stepExecution.getStepExecutionId(), BatchStatus.FAILED, newExitStatus, markFailedTime);
                    this.persistenceManagerService.updateRemotablePartitionOnRecovery(this.psu, partition);
                }
                catch (Exception exception) {
                    void updateExc;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.ws.impl.WSStartupRecoveryServiceImpl", (String)"107", (Object)this, (Object[])new Object[0]);
                    logger.log(Level.WARNING, "partition.recovery.failed", new Object[]{key, updateExc});
                }
            }
        }
        catch (Exception remotablePartitions) {
            void exception;
            FFDCFilter.processException((Throwable)remotablePartitions, (String)"com.ibm.jbatch.container.ws.impl.WSStartupRecoveryServiceImpl", (String)"111", (Object)this, (Object[])new Object[0]);
            logger.log(Level.WARNING, "recovery.failed", (Throwable)exception);
        }
        WSStartupRecoveryServiceImpl wSStartupRecoveryServiceImpl = this;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSStartupRecoveryServiceImpl = wSStartupRecoveryServiceImpl;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSStartupRecoveryServiceImpl", "recoverLocalPartitionsInInflightStates", wSStartupRecoveryServiceImpl);
        }
        return wSStartupRecoveryServiceImpl;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSStartupRecoveryServiceImpl recoverLocalJobsInInflightStates() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.impl.WSStartupRecoveryServiceImpl", "recoverLocalJobsInInflightStates", new Object[0]);
        }
        String methodName = "recoverLocalJobsInInflightStates";
        try {
            List<JobExecutionEntity> executionInstances = this.persistenceManagerService.getJobExecutionsRunningLocalToServer(this.psu);
            for (JobExecutionEntity executionInstance : executionInstances) {
                long executionId = executionInstance.getExecutionId();
                long jobInstanceId = executionInstance.getInstanceId();
                String newExitStatus = executionInstance.getExitStatus();
                if (newExitStatus == null) {
                    newExitStatus = BatchStatus.FAILED.name();
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(methodName + ": marking [job instance=" + jobInstanceId + ",old batchStatus=" + executionInstance.getBatchStatus().name() + " to new batchStatus=FAILED, new exitStatus=" + newExitStatus + "]");
                }
                Date markFailedTime = new Date();
                try {
                    this.persistenceManagerService.updateJobExecutionAndInstanceFinalStatus(this.psu, executionId, BatchStatus.FAILED, newExitStatus, markFailedTime);
                }
                catch (Exception exception) {
                    void updateExc;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.ws.impl.WSStartupRecoveryServiceImpl", (String)"150", (Object)this, (Object[])new Object[0]);
                    logger.log(Level.WARNING, "job.recovery.failed", new Object[]{jobInstanceId, updateExc});
                }
                for (StepExecution stepExecution : this.persistenceManagerService.getStepThreadExecutionsRunning(this.psu, executionId)) {
                    String newStepExitStatus = stepExecution.getExitStatus();
                    if (newStepExitStatus == null) {
                        newStepExitStatus = BatchStatus.FAILED.name();
                    }
                    logger.fine(methodName + ": marking [step execution=" + stepExecution.getStepExecutionId() + ",old batchStatus=" + stepExecution.getBatchStatus().name() + " to new batchStatus=FAILED, new step exitStatus=" + newStepExitStatus + "]");
                    this.persistenceManagerService.updateStepExecutionOnRecovery(this.psu, stepExecution.getStepExecutionId(), BatchStatus.FAILED, newStepExitStatus, markFailedTime);
                }
            }
        }
        catch (Exception executionInstances) {
            void exception;
            FFDCFilter.processException((Throwable)executionInstances, (String)"com.ibm.jbatch.container.ws.impl.WSStartupRecoveryServiceImpl", (String)"165", (Object)this, (Object[])new Object[0]);
            logger.log(Level.WARNING, "recovery.failed", (Throwable)exception);
        }
        WSStartupRecoveryServiceImpl wSStartupRecoveryServiceImpl = this;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSStartupRecoveryServiceImpl = wSStartupRecoveryServiceImpl;
            logger.exiting("com.ibm.jbatch.container.ws.impl.WSStartupRecoveryServiceImpl", "recoverLocalJobsInInflightStates", wSStartupRecoveryServiceImpl);
        }
        return wSStartupRecoveryServiceImpl;
    }
}

