/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel.reader;

import com.ibm.websphere.logging.hpel.reader.HpelFormatter;
import com.ibm.websphere.logging.hpel.reader.LogQueryBean;
import com.ibm.websphere.logging.hpel.reader.LogRepositoryException;
import com.ibm.websphere.logging.hpel.reader.RemoteAllResults;
import com.ibm.websphere.logging.hpel.reader.RemoteInstanceDetails;
import com.ibm.websphere.logging.hpel.reader.RemoteInstanceResult;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import com.ibm.websphere.logging.hpel.reader.RepositoryPointer;
import com.ibm.websphere.logging.hpel.reader.RepositoryReader;
import com.ibm.websphere.logging.hpel.reader.ServerInstanceLogRecordList;
import com.ibm.ws.logging.hpel.impl.ServerInstanceLogRecordListImpl;
import com.ibm.ws.logging.object.hpel.RepositoryLogRecordImpl;
import java.util.HashSet;
import java.util.Locale;

public class RemoteResultCollector {
    private final RepositoryReader logReader;

    public RemoteResultCollector(RepositoryReader logReader) {
        this.logReader = logReader;
    }

    public RemoteAllResults getLogLists(LogQueryBean logQueryBean, RepositoryPointer after) throws LogRepositoryException {
        RemoteAllResults result = new RemoteAllResults(logQueryBean);
        Iterable<ServerInstanceLogRecordList> lists = after == null ? this.logReader.getLogLists(logQueryBean) : this.logReader.getLogLists(after, logQueryBean);
        for (ServerInstanceLogRecordList instance : lists) {
            result.addInstance(instance.getStartTime());
        }
        return result;
    }

    public RemoteInstanceResult getLogListForServerInstance(RemoteInstanceDetails indicator, RepositoryPointer after, int offset, int maxRecords, Locale locale) throws LogRepositoryException {
        RemoteInstanceResult result;
        ServerInstanceLogRecordList instance;
        if (after == null) {
            instance = this.logReader.getLogListForServerInstance(indicator.getStartTime(), indicator.getQuery());
            for (String key : indicator.getProcPath()) {
                if ((instance = instance.getChildren().get(key)) != null) continue;
                return new RemoteInstanceResult(null, null, new HashSet<String>());
            }
        } else {
            instance = this.logReader.getLogListForServerInstance(after, indicator.getQuery());
        }
        if (indicator.getCache() == null) {
            result = new RemoteInstanceResult(instance.getStartTime(), instance.getHeader(), instance.getChildren().keySet());
        } else {
            result = new RemoteInstanceResult(null, null, new HashSet<String>());
            if (instance instanceof ServerInstanceLogRecordListImpl) {
                ((ServerInstanceLogRecordListImpl)instance).setCache(indicator.getCache());
            }
        }
        if (maxRecords != 0) {
            for (RepositoryLogRecord record : instance.range(offset, maxRecords)) {
                if (locale != null && !locale.toString().equals(record.getMessageLocale()) && record instanceof RepositoryLogRecordImpl) {
                    RepositoryLogRecordImpl recordImpl = (RepositoryLogRecordImpl)record;
                    recordImpl.setLocalizedMessage(HpelFormatter.translateMessage(record, locale));
                    recordImpl.setMessageLocale(locale.toString());
                }
                result.addRecord(record);
            }
        }
        if (instance instanceof ServerInstanceLogRecordListImpl && (indicator.getCache() == null || !indicator.getCache().isComplete())) {
            result.setCache(((ServerInstanceLogRecordListImpl)instance).getCache());
        }
        return result;
    }
}

