/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.encoder.servlet;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.net.ThreadLocalHttpServletResponseProxy;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.NonnullSupplier;
import org.opensaml.messaging.encoder.AbstractMessageEncoder;
import org.opensaml.messaging.encoder.servlet.HttpServletResponseMessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpServletResponseMessageEncoder
extends AbstractMessageEncoder
implements HttpServletResponseMessageEncoder {
    private final Logger log = LoggerFactory.getLogger(AbstractHttpServletResponseMessageEncoder.class);
    @Nullable
    private NonnullSupplier<HttpServletResponse> httpServletResponseSupplier;

    @Override
    @Nullable
    public HttpServletResponse getHttpServletResponse() {
        if (this.httpServletResponseSupplier == null) {
            return null;
        }
        return (HttpServletResponse)this.httpServletResponseSupplier.get();
    }

    @Override
    public synchronized void setHttpServletResponseSupplier(@Nullable NonnullSupplier<HttpServletResponse> supplier) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.httpServletResponseSupplier = supplier;
    }

    @Nullable
    public NonnullSupplier<HttpServletResponse> getHttpServletResponseSupplier() {
        return this.httpServletResponseSupplier;
    }

    @Override
    @Deprecated
    public synchronized void setHttpServletResponse(final @Nullable HttpServletResponse response) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"setHttpServletResponse", (String)this.getClass().getCanonicalName(), (String)"setHttpServletResponseSupplier");
        if (response != null && !(response instanceof ThreadLocalHttpServletResponseProxy)) {
            this.log.warn("Unsafe HttpServletRequest injected");
        }
        this.httpServletResponseSupplier = new NonnullSupplier<HttpServletResponse>(){

            public HttpServletResponse get() {
                return response;
            }
        };
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getHttpServletResponse() == null) {
            throw new ComponentInitializationException("HTTP servlet response cannot be null");
        }
    }
}

