/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.encoder;

import jakarta.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponent;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.messaging.encoder.MessageEncodingException;

public abstract class AbstractMessageEncoder
extends AbstractInitializableComponent
implements MessageEncoder,
UnmodifiableComponent {
    @Nullable
    private MessageContext messageContext;

    @Override
    public synchronized void setMessageContext(@Nullable MessageContext context) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.messageContext = context;
    }

    @Override
    public void encode() throws MessageEncodingException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.doEncode();
    }

    @Override
    public void prepareContext() throws MessageEncodingException {
    }

    @Nullable
    protected MessageContext getMessageContext() {
        return this.messageContext;
    }

    protected void doDestroy() {
        this.messageContext = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.messageContext == null) {
            throw new ComponentInitializationException("Message context cannot be null");
        }
    }

    protected abstract void doEncode() throws MessageEncodingException;
}

