/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.context.navigate;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;

public class RecursiveTypedParentContextLookup<StartContext extends BaseContext, ParentContext extends BaseContext>
implements ContextDataLookupFunction<StartContext, ParentContext> {
    @Nonnull
    private Class<ParentContext> parentClass;

    public RecursiveTypedParentContextLookup(@Nonnull @ParameterName(name="targetClass") Class<ParentContext> targetClass) {
        this.parentClass = (Class)Constraint.isNotNull(targetClass, (String)"Parent Class may not be null");
    }

    @Override
    @Nullable
    public ParentContext apply(@Nullable StartContext input) {
        if (input == null) {
            return null;
        }
        for (BaseContext current = ((BaseContext)input).getParent(); current != null; current = current.getParent()) {
            if (!this.parentClass.isInstance(current)) continue;
            return (ParentContext)((BaseContext)this.parentClass.cast(current));
        }
        return null;
    }
}

