/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.web.WebSSOUtils;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.sp.Solicited;
import com.ibm.ws.security.saml.sso20.sp.Unsolicited;
import com.ibm.wsspi.security.tai.TAIResult;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Initiator {
    public static final TraceComponent tc = Tr.register(Initiator.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    SsoSamlService ssoService = null;
    WebSSOUtils webssoUtils = new WebSSOUtils();
    static final long serialVersionUID = -5094097017091432874L;

    public Initiator(SsoSamlService service) {
        this.ssoService = service;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Solicited(" + service.getProviderId() + ")"), (Object[])new Object[0]);
        }
    }

    public TAIResult forwardRequestToSamlIdp(HttpServletRequest req, HttpServletResponse resp) throws WebTrustAssociationFailedException, SamlException {
        String loginPageUrl;
        SsoConfig samlConfig = this.ssoService.getConfig();
        boolean createSession = samlConfig.createSession();
        if (createSession) {
            try {
                req.getSession(true);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.internal.Initiator", (String)"71", (Object)this, (Object[])new Object[]{req, resp});
            }
        }
        if ((loginPageUrl = samlConfig.getLoginPageURL()) != null && !loginPageUrl.isEmpty()) {
            Unsolicited spUnsolicited = new Unsolicited(this.ssoService);
            return spUnsolicited.sendRequestToLoginPageUrl(req, resp, loginPageUrl);
        }
        Solicited spSolicited = new Solicited(this.ssoService);
        return spSolicited.sendAuthRequestToIdp(req, resp);
    }
}

