/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.derivation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.derivation.KeyDerivationException;

public final class KeyDerivationSupport {
    private KeyDerivationSupport() {
    }

    @Nonnull
    public static String getJCAKeyAlgorithm(@Nonnull String algorithmURI) throws KeyDerivationException {
        Constraint.isNotNull((Object)algorithmURI, (String)"Algorithm URI was null");
        String jcaKeyAlgorithm = AlgorithmSupport.getKeyAlgorithm(algorithmURI);
        if (jcaKeyAlgorithm == null) {
            throw new KeyDerivationException("Could not determine JCA key algorithm from URI: " + algorithmURI);
        }
        return jcaKeyAlgorithm;
    }

    @Nonnull
    public static Integer getEffectiveKeyLength(@Nonnull String algorithmURI, @Nullable Integer specifiedKeyLength) throws KeyDerivationException {
        Constraint.isNotNull((Object)algorithmURI, (String)"Algorithm URI was null");
        Integer algoKeyLength = AlgorithmSupport.getKeyLength(algorithmURI);
        if (algoKeyLength == null) {
            if (specifiedKeyLength == null) {
                throw new KeyDerivationException(String.format("Could not determine algorithm key length from URI '%s'and no length was specified", algorithmURI));
            }
            return specifiedKeyLength;
        }
        if (specifiedKeyLength != null && !specifiedKeyLength.equals(algoKeyLength)) {
            throw new KeyDerivationException(String.format("Algorithm URI '%s' key length (%d) does not match specified (%d)", algorithmURI, algoKeyLength, specifiedKeyLength));
        }
        return algoKeyLength;
    }
}

