/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement.impl;

import jakarta.annotation.Nonnull;
import java.util.Collection;
import javax.crypto.SecretKey;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.agreement.KeyAgreementCredential;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameter;
import org.opensaml.xmlsec.agreement.KeyAgreementParameters;
import org.opensaml.xmlsec.agreement.KeyAgreementProcessor;
import org.opensaml.xmlsec.agreement.impl.BasicKeyAgreementCredential;
import org.opensaml.xmlsec.agreement.impl.PrivateCredential;
import org.opensaml.xmlsec.agreement.impl.StaticStaticMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKeyAgreementProcessor
implements KeyAgreementProcessor {
    private final Logger log = LoggerFactory.getLogger(AbstractKeyAgreementProcessor.class);

    @Override
    @Nonnull
    public KeyAgreementCredential execute(@Nonnull Credential publicCredential, @Nonnull String keyAlgorithm, @Nonnull KeyAgreementParameters inputParameters) throws KeyAgreementException {
        KeyAgreementParameters parameters = new KeyAgreementParameters((Collection<KeyAgreementParameter>)((Object)inputParameters));
        Credential privateCredential = this.obtainPrivateCredential(publicCredential, parameters);
        byte[] secret = this.generateAgreementSecret(publicCredential, privateCredential, parameters);
        SecretKey derivedKey = this.deriveSecretKey(secret, keyAlgorithm, parameters);
        return this.buildKeyAgreementCredential(derivedKey, publicCredential, privateCredential, parameters);
    }

    @Nonnull
    protected Credential obtainPrivateCredential(@Nonnull Credential publicCredential, @Nonnull KeyAgreementParameters parameters) throws KeyAgreementException {
        if (parameters.contains(PrivateCredential.class)) {
            this.log.debug("Found supplied PrivateCredential in KeyAgreementParameters");
            return ((PrivateCredential)parameters.get(PrivateCredential.class)).getCredential();
        }
        return null;
    }

    @Nonnull
    protected abstract byte[] generateAgreementSecret(@Nonnull Credential var1, @Nonnull Credential var2, @Nonnull KeyAgreementParameters var3) throws KeyAgreementException;

    @Nonnull
    protected abstract SecretKey deriveSecretKey(@Nonnull byte[] var1, @Nonnull String var2, @Nonnull KeyAgreementParameters var3) throws KeyAgreementException;

    @Nonnull
    protected KeyAgreementCredential buildKeyAgreementCredential(@Nonnull SecretKey derivedKey, @Nonnull Credential publicCredential, @Nonnull Credential privateCredential, @Nonnull KeyAgreementParameters parameters) throws KeyAgreementException {
        Credential recipient = null;
        Credential originator = null;
        if (parameters.contains(PrivateCredential.class) && !parameters.contains(StaticStaticMode.class)) {
            recipient = privateCredential;
            originator = publicCredential;
        } else {
            recipient = publicCredential;
            originator = privateCredential;
        }
        BasicKeyAgreementCredential cred = new BasicKeyAgreementCredential(derivedKey, this.getAlgorithm(), originator, recipient);
        cred.getParameters().addAll((Collection)((Object)parameters));
        return cred;
    }
}

