/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.collection.LazyMap;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.AssertionValidator;
import org.opensaml.saml.saml2.assertion.ConditionValidator;
import org.opensaml.saml.saml2.assertion.StatementValidator;
import org.opensaml.saml.saml2.assertion.SubjectConfirmationValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Statement;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignaturePrevalidator;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML20AssertionValidator {
    @Nonnull
    public static final Duration DEFAULT_CLOCK_SKEW = Duration.ofMinutes(5L);
    @Nonnull
    public static final Duration DEFAULT_LIFETIME = Duration.ofMinutes(5L);
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML20AssertionValidator.class);
    @Nonnull
    @NonnullElements
    private LazyMap<QName, ConditionValidator> conditionValidators = new LazyMap();
    @Nonnull
    @NonnullElements
    private LazyMap<String, SubjectConfirmationValidator> subjectConfirmationValidators;
    @Nonnull
    @NonnullElements
    private LazyMap<QName, StatementValidator> statementValidators;
    @Nullable
    private AssertionValidator assertionValidator;
    @Nullable
    private SignatureTrustEngine trustEngine;
    @Nullable
    private SignaturePrevalidator signaturePrevalidator;

    public SAML20AssertionValidator(@Nullable Collection<ConditionValidator> newConditionValidators, @Nullable Collection<SubjectConfirmationValidator> newConfirmationValidators, @Nullable Collection<StatementValidator> newStatementValidators, @Nullable AssertionValidator newAssertionValidator, @Nullable SignatureTrustEngine newTrustEngine, @Nullable SignaturePrevalidator newSignaturePrevalidator) {
        if (newConditionValidators != null) {
            for (ConditionValidator conditionValidator : newConditionValidators) {
                if (conditionValidator == null) continue;
                this.conditionValidators.put((Object)conditionValidator.getServicedCondition(), (Object)conditionValidator);
            }
        }
        this.subjectConfirmationValidators = new LazyMap();
        if (newConfirmationValidators != null) {
            for (SubjectConfirmationValidator subjectConfirmationValidator : newConfirmationValidators) {
                if (subjectConfirmationValidator == null) continue;
                this.subjectConfirmationValidators.put((Object)subjectConfirmationValidator.getServicedMethod(), (Object)subjectConfirmationValidator);
            }
        }
        this.statementValidators = new LazyMap();
        if (newStatementValidators != null) {
            for (StatementValidator statementValidator : newStatementValidators) {
                if (statementValidator == null) continue;
                this.statementValidators.put((Object)statementValidator.getServicedStatement(), (Object)statementValidator);
            }
        }
        this.assertionValidator = newAssertionValidator;
        this.trustEngine = newTrustEngine;
        this.signaturePrevalidator = newSignaturePrevalidator;
    }

    @Deprecated
    public SAML20AssertionValidator(@Nullable Collection<ConditionValidator> newConditionValidators, @Nullable Collection<SubjectConfirmationValidator> newConfirmationValidators, @Nullable Collection<StatementValidator> newStatementValidators, @Nullable SignatureTrustEngine newTrustEngine, @Nullable SignaturePrevalidator newSignaturePrevalidator) {
        this(newConditionValidators, newConfirmationValidators, newStatementValidators, null, newTrustEngine, newSignaturePrevalidator);
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"SAML20AssertionValidator 5 argument constructor", null, (String)"SAML20AssertionValidator 6 argument constructor");
    }

    @Nonnull
    public static Duration getLifetime(@Nonnull ValidationContext context) {
        return SAML20AssertionValidator.getDurationParam(context, "saml2.Lifetime", DEFAULT_LIFETIME);
    }

    @Nonnull
    public static Duration getClockSkew(@Nonnull ValidationContext context) {
        return SAML20AssertionValidator.getDurationParam(context, "saml2.ClockSkew", DEFAULT_CLOCK_SKEW);
    }

    private static Duration getDurationParam(@Nonnull ValidationContext context, @Nonnull String paramName, @Nonnull Duration defaultDuration) {
        Duration duration = defaultDuration;
        if (context.getStaticParameters().containsKey(paramName)) {
            try {
                Object raw = context.getStaticParameters().get(paramName);
                if (raw instanceof Duration) {
                    duration = (Duration)raw;
                } else if (raw instanceof Long) {
                    duration = Duration.ofMillis((Long)raw);
                    DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)paramName, null, (String)Duration.class.getName());
                }
                if (duration.isZero()) {
                    duration = defaultDuration;
                } else if (duration.isNegative()) {
                    duration = duration.abs();
                }
            }
            catch (ClassCastException e) {
                duration = defaultDuration;
            }
        }
        return duration;
    }

    @Nonnull
    public ValidationResult validate(@Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
        this.log(assertion, context);
        ValidationResult result = this.validateBasicData(assertion, context);
        if (result != ValidationResult.VALID) {
            return result;
        }
        result = this.validateSignature(assertion, context);
        if (result != ValidationResult.VALID) {
            return result;
        }
        result = this.validateConditions(assertion, context);
        if (result != ValidationResult.VALID) {
            return result;
        }
        result = this.validateSubjectConfirmation(assertion, context);
        if (result != ValidationResult.VALID) {
            return result;
        }
        result = this.validateStatements(assertion, context);
        if (result != ValidationResult.VALID) {
            return result;
        }
        if (this.assertionValidator != null) {
            return this.assertionValidator.validate(assertion, context);
        }
        return ValidationResult.VALID;
    }

    protected void log(@Nonnull Assertion assertion, @Nonnull ValidationContext context) {
        if (this.log.isTraceEnabled()) {
            try {
                Element dom = XMLObjectSupport.marshall(assertion);
                this.log.trace("SAML 2 Assertion being validated:\n{}", (Object)SerializeSupport.prettyPrintXML((Node)dom));
            }
            catch (MarshallingException e) {
                this.log.error("Unable to marshall SAML 2 Assertion for logging purposes", (Throwable)e);
            }
            this.log.trace("SAML 2 Assertion ValidationContext - static parameters: {}", context.getStaticParameters());
            this.log.trace("SAML 2 Assertion ValidationContext - dynamic parameters: {}", context.getDynamicParameters());
        }
    }

    @Nonnull
    protected ValidationResult validateBasicData(@Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
        ValidationResult result = this.validateVersion(assertion, context);
        if (result != ValidationResult.VALID) {
            return result;
        }
        result = this.validateIssueInstant(assertion, context);
        if (result != ValidationResult.VALID) {
            return result;
        }
        result = this.validateIssuer(assertion, context);
        if (result != ValidationResult.VALID) {
            return result;
        }
        return ValidationResult.VALID;
    }

    @Nonnull
    protected ValidationResult validateVersion(@Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
        if (assertion.getVersion() != SAMLVersion.VERSION_20) {
            context.setValidationFailureMessage(String.format("Assertion '%s' is not a SAML 2.0 version Assertion", assertion.getID()));
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateIssueInstant(@Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
        if (assertion.getIssueInstant() == null) {
            context.setValidationFailureMessage(String.format("Assertion '%s' did not contain the required IssueInstant", assertion.getID()));
            return ValidationResult.INVALID;
        }
        Instant issueInstant = assertion.getIssueInstant();
        Duration clockSkew = SAML20AssertionValidator.getClockSkew(context);
        Duration lifetime = SAML20AssertionValidator.getLifetime(context);
        Instant now = Instant.now();
        Instant latestValid = now.plus(clockSkew.abs());
        Instant expiration = issueInstant.plus(clockSkew.abs()).plus(lifetime.abs());
        if (issueInstant.isAfter(latestValid)) {
            this.log.warn("Assertion was not yet valid: IssueInstant: '{}', latest valid: '{}'", (Object)issueInstant, (Object)latestValid);
            context.setValidationFailureMessage("Assertion IssueInstant was invalid, issued in future");
            return ValidationResult.INVALID;
        }
        if (expiration.isBefore(now)) {
            this.log.warn("Assertion IssueInstant was expired: IssueInstant: '{}', expiration: '{}', now: '{}'", new Object[]{issueInstant, expiration, now});
            context.setValidationFailureMessage("Assertion IssueInstant was invalid, expired");
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateIssuer(@Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
        Set validIssuers;
        String issuer = null;
        if (assertion.getIssuer() != null) {
            issuer = StringSupport.trimOrNull((String)assertion.getIssuer().getValue());
        }
        if (issuer == null) {
            this.log.warn("Assertion Issuer was missing and was required");
            context.setValidationFailureMessage("Assertion Issuer was missing and was required");
            return ValidationResult.INVALID;
        }
        this.log.debug("Evaluating Assertion Issuer of : {}", (Object)issuer);
        try {
            validIssuers = (Set)context.getStaticParameters().get("saml2.ValidIssuers");
        }
        catch (ClassCastException e) {
            this.log.warn("The value of the static validation parameter '{}' was not java.util.Set<String>", (Object)"saml2.ValidIssuers");
            context.setValidationFailureMessage("Unable to determine list of valid issuers");
            return ValidationResult.INDETERMINATE;
        }
        if (validIssuers == null || validIssuers.isEmpty()) {
            this.log.warn("Set of valid issuers was not available from the validation context, unable to evaluate Issuer");
            return ValidationResult.VALID;
        }
        if (validIssuers.contains(issuer)) {
            this.log.debug("Matched valid issuer: {}", (Object)issuer);
            return ValidationResult.VALID;
        }
        this.log.debug("Failed to match Issuer to any supplied valid issuers: {}", (Object)validIssuers);
        context.setValidationFailureMessage(String.format("Issuer of Assertion '%s' did not match any valid issuers", assertion.getID()));
        return ValidationResult.INVALID;
    }

    @Nonnull
    protected ValidationResult validateSignature(@Nonnull Assertion token, @Nonnull ValidationContext context) throws AssertionValidationException {
        Boolean signatureRequired = (Boolean)context.getStaticParameters().get("saml2.SignatureRequired");
        if (signatureRequired == null) {
            signatureRequired = Boolean.TRUE;
        }
        if (!token.isSigned()) {
            if (signatureRequired.booleanValue()) {
                context.setValidationFailureMessage("Assertion was required to be signed, but was not");
                return ValidationResult.INVALID;
            }
            this.log.debug("Assertion was not required to be signed, and was not signed.  Skipping further signature evaluation");
            return ValidationResult.VALID;
        }
        return this.performSignatureValidation(token, context);
    }

    @Nonnull
    protected ValidationResult performSignatureValidation(@Nonnull Assertion token, @Nonnull ValidationContext context) throws AssertionValidationException {
        SignatureTrustEngine signatureTrustEngine = this.getSignatureValidationTrustEngine(token, context);
        if (signatureTrustEngine == null) {
            this.log.warn("Signature validation was necessary, but no signature trust engine was available");
            context.setValidationFailureMessage("Assertion signature could not be evaluated due to internal error");
            return ValidationResult.INDETERMINATE;
        }
        Signature signature = token.getSignature();
        String tokenIssuer = null;
        if (token.getIssuer() != null) {
            tokenIssuer = token.getIssuer().getValue();
        }
        this.log.debug("Attempting signature validation on Assertion '{}' from Issuer '{}'", (Object)token.getID(), (Object)tokenIssuer);
        try {
            SignaturePrevalidator prevalidator = this.getSignatureValidationPrevalidator(token, context);
            if (prevalidator != null) {
                prevalidator.validate(signature);
            } else {
                this.log.warn("No SignaturePrevalidator was available, skipping pre-validation");
            }
        }
        catch (SignatureException e) {
            String msg = String.format("Assertion Signature failed pre-validation: %s", e.getMessage());
            this.log.warn(msg);
            context.setValidationFailureMessage(msg);
            return ValidationResult.INVALID;
        }
        CriteriaSet criteriaSet = this.getSignatureValidationCriteriaSet(token, context);
        try {
            if (signatureTrustEngine.validate(signature, criteriaSet)) {
                this.log.debug("Validation of signature of Assertion '{}' from Issuer '{}' was successful", (Object)token.getID(), (Object)tokenIssuer);
                return ValidationResult.VALID;
            }
            String msg = String.format("Signature of Assertion '%s' from Issuer '%s' was not valid", token.getID(), tokenIssuer);
            this.log.warn(msg);
            context.setValidationFailureMessage(msg);
            return ValidationResult.INVALID;
        }
        catch (SecurityException e) {
            String msg = String.format("A problem was encountered evaluating the signature over Assertion with ID '%s': %s", token.getID(), e.getMessage());
            this.log.warn(msg);
            context.setValidationFailureMessage(msg);
            return ValidationResult.INDETERMINATE;
        }
    }

    @Nonnull
    protected SignatureTrustEngine getSignatureValidationTrustEngine(@Nonnull Assertion token, @Nonnull ValidationContext context) {
        SignatureTrustEngine contextEngine = (SignatureTrustEngine)context.getStaticParameters().get("saml2.SignatureValidationTrustEngine");
        if (contextEngine != null) {
            return contextEngine;
        }
        return this.trustEngine;
    }

    @Nonnull
    protected SignaturePrevalidator getSignatureValidationPrevalidator(@Nonnull Assertion token, @Nonnull ValidationContext context) {
        SignaturePrevalidator contextPrevalidator = (SignaturePrevalidator)context.getStaticParameters().get("saml2.SignatureValidationPrevalidator");
        if (contextPrevalidator != null) {
            return contextPrevalidator;
        }
        return this.signaturePrevalidator;
    }

    @Nonnull
    protected CriteriaSet getSignatureValidationCriteriaSet(@Nonnull Assertion token, @Nonnull ValidationContext context) {
        CriteriaSet criteriaSet = (CriteriaSet)context.getStaticParameters().get("saml2.SignatureValidationCriteriaSet");
        if (criteriaSet == null) {
            criteriaSet = new CriteriaSet();
        }
        if (!criteriaSet.contains(EntityIdCriterion.class)) {
            String issuer = null;
            if (token.getIssuer() != null) {
                issuer = StringSupport.trimOrNull((String)token.getIssuer().getValue());
            }
            if (issuer != null) {
                criteriaSet.add((Object)new EntityIdCriterion(issuer));
            }
        }
        if (!criteriaSet.contains(UsageCriterion.class)) {
            criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        }
        return criteriaSet;
    }

    @Nonnull
    protected ValidationResult validateConditions(@Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
        ValidationResult requiredConditionsResult = this.validateRequiredConditions(assertion, context);
        if (requiredConditionsResult != ValidationResult.VALID) {
            return requiredConditionsResult;
        }
        Conditions conditions = assertion.getConditions();
        if (conditions == null) {
            this.log.debug("Assertion contained no Conditions element");
            return ValidationResult.VALID;
        }
        ValidationResult timeboundsResult = this.validateConditionsTimeBounds(assertion, context);
        if (timeboundsResult != ValidationResult.VALID) {
            return timeboundsResult;
        }
        for (Condition condition : conditions.getConditions()) {
            ConditionValidator validator = (ConditionValidator)this.conditionValidators.get((Object)condition.getElementQName());
            if (validator == null && condition.getSchemaType() != null) {
                validator = (ConditionValidator)this.conditionValidators.get((Object)condition.getSchemaType());
            }
            if (validator == null) {
                String msg = String.format("Unknown Condition '%s' of type '%s' in assertion '%s'", condition.getElementQName(), condition.getSchemaType(), assertion.getID());
                this.log.debug(msg);
                context.setValidationFailureMessage(msg);
                return ValidationResult.INDETERMINATE;
            }
            if (validator.validate(condition, assertion, context) == ValidationResult.VALID) continue;
            String msg = String.format("Condition '%s' of type '%s' in assertion '%s' was not valid.", condition.getElementQName(), condition.getSchemaType(), assertion.getID());
            if (context.getValidationFailureMessage() != null) {
                msg = msg + ": " + context.getValidationFailureMessage();
            }
            this.log.debug(msg);
            context.setValidationFailureMessage(msg);
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateRequiredConditions(@Nonnull Assertion assertion, @Nonnull ValidationContext context) {
        Set requiredConditions = (Set)context.getStaticParameters().get("saml2.Conditions.RequiredConditions");
        if (requiredConditions == null || requiredConditions.isEmpty()) {
            this.log.debug("No Conditions were indicated as required");
            return ValidationResult.VALID;
        }
        Conditions conditions = assertion.getConditions();
        if (conditions == null || conditions.getConditions().isEmpty()) {
            this.log.warn("At least 1 Condition was indicated as required, but Assertion contained no Conditions");
            context.setValidationFailureMessage("At least 1 Condition was indicated as required, but Assertion contained no Conditions");
            return ValidationResult.INVALID;
        }
        for (QName requiredCondition : requiredConditions) {
            List<Condition> found = conditions.getConditions(requiredCondition);
            if (found != null && !found.isEmpty()) continue;
            String msg = String.format("Condition '%s' was required, but was not found in assertion '%s'", requiredCondition, assertion.getID());
            if (context.getValidationFailureMessage() != null) {
                msg = msg + ": " + context.getValidationFailureMessage();
            }
            this.log.warn(msg);
            context.setValidationFailureMessage(msg);
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    @Nonnull
    protected ValidationResult validateConditionsTimeBounds(@Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
        Conditions conditions = assertion.getConditions();
        if (conditions == null) {
            return ValidationResult.VALID;
        }
        Instant now = Instant.now();
        Duration clockSkew = SAML20AssertionValidator.getClockSkew(context);
        Instant notBefore = conditions.getNotBefore();
        this.log.debug("Evaluating Conditions NotBefore '{}' against 'skewed now' time '{}'", (Object)notBefore, (Object)now.plus(clockSkew));
        if (notBefore != null && notBefore.isAfter(now.plus(clockSkew))) {
            context.setValidationFailureMessage(String.format("Assertion '%s' with NotBefore condition of '%s' is not yet valid", assertion.getID(), notBefore));
            return ValidationResult.INVALID;
        }
        Instant notOnOrAfter = conditions.getNotOnOrAfter();
        this.log.debug("Evaluating Conditions NotOnOrAfter '{}' against 'skewed now' time '{}'", (Object)notOnOrAfter, (Object)now.minus(clockSkew));
        if (notOnOrAfter != null && notOnOrAfter.isBefore(now.minus(clockSkew))) {
            context.setValidationFailureMessage(String.format("Assertion '%s' with NotOnOrAfter condition of '%s' is no longer valid", assertion.getID(), notOnOrAfter));
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    @Nonnull
    protected ValidationResult validateSubjectConfirmation(@Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
        Subject assertionSubject = assertion.getSubject();
        if (assertionSubject == null) {
            this.log.debug("Assertion contains no Subject, skipping subject confirmation");
            return ValidationResult.VALID;
        }
        List<SubjectConfirmation> confirmations = assertionSubject.getSubjectConfirmations();
        if (confirmations == null || confirmations.isEmpty()) {
            this.log.debug("Assertion contains no SubjectConfirmations, skipping subject confirmation");
            return ValidationResult.VALID;
        }
        this.log.debug("Assertion contains at least 1 SubjectConfirmation, proceeding with subject confirmation");
        for (SubjectConfirmation confirmation : confirmations) {
            SubjectConfirmationValidator validator = (SubjectConfirmationValidator)this.subjectConfirmationValidators.get((Object)confirmation.getMethod());
            if (validator == null) continue;
            try {
                if (validator.validate(confirmation, assertion, context) != ValidationResult.VALID) continue;
                context.getDynamicParameters().put("saml2.ConfirmedSubjectConfirmation", confirmation);
                return ValidationResult.VALID;
            }
            catch (AssertionValidationException e) {
                this.log.warn("Error while executing subject confirmation validation " + validator.getClass().getName(), (Throwable)e);
            }
        }
        String msg = String.format("No subject confirmation methods were met for assertion with ID '%s'", assertion.getID());
        this.log.debug(msg);
        context.setValidationFailureMessage(msg);
        return ValidationResult.INVALID;
    }

    @Nonnull
    protected ValidationResult validateStatements(@Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
        List<Statement> statements = assertion.getStatements();
        if (statements == null || statements.isEmpty()) {
            return ValidationResult.VALID;
        }
        for (Statement statement : statements) {
            ValidationResult result;
            StatementValidator validator = (StatementValidator)this.statementValidators.get((Object)statement.getElementQName());
            if (validator == null && statement.getSchemaType() != null) {
                validator = (StatementValidator)this.statementValidators.get((Object)statement.getSchemaType());
            }
            if (validator == null || (result = validator.validate(statement, assertion, context)) == ValidationResult.VALID) continue;
            return result;
        }
        return ValidationResult.VALID;
    }
}

