/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jaas.common.callback.AuthenticationHelper;
import com.ibm.ws.security.jwtsso.token.proxy.JwtSSOTokenHelper;
import com.ibm.ws.security.token.TokenManager;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebSecurityHelperImpl {
    private static final TraceComponent tc = Tr.register(WebSecurityHelperImpl.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    private static WebAppSecurityConfig webAppSecConfig = null;
    private static final AtomicServiceReference<TokenManager> tokenManagerRef = new AtomicServiceReference("tokenManager");
    static final long serialVersionUID = 533242549032213653L;

    public static void setWebAppSecurityConfig(WebAppSecurityConfig webAppSecConfig) {
        WebSecurityHelperImpl.webAppSecConfig = webAppSecConfig;
    }

    /*
     * WARNING - void declaration
     */
    public static Cookie getSSOCookieFromSSOToken(String ... removeAttributes) throws Exception {
        Cookie ltpaCookie = null;
        if (webAppSecConfig == null) {
            return null;
        }
        try {
            Subject subject = WSSubject.getRunAsSubject();
            if (subject == null) {
                subject = WSSubject.getCallerSubject();
            }
            if (subject != null) {
                ltpaCookie = WebSecurityHelperImpl.getLTPACookie(subject, removeAttributes);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No subjects on the thread", (Object[])new Object[0]);
            }
        }
        catch (Exception subject) {
            void e;
            FFDCFilter.processException((Throwable)subject, (String)"com.ibm.ws.webcontainer.security.internal.WebSecurityHelperImpl", (String)"78", null, (Object[])new Object[]{removeAttributes});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getSSOCookieFromSSOTokenWithOutAttrs caught exception: " + e.getMessage()), (Object[])new Object[0]);
            }
            throw e;
        }
        return ltpaCookie;
    }

    public static WebAppSecurityConfig getWebAppSecurityConfig() {
        return webAppSecConfig;
    }

    public static String getJwtCookieName() {
        return JwtSSOTokenHelper.getJwtCookieName();
    }

    private static Cookie constructLTPACookieObj(SingleSignonToken ssoToken) {
        byte[] ssoTokenBytes = ssoToken.getBytes();
        return WebSecurityHelperImpl.createCookie(ssoTokenBytes);
    }

    /*
     * WARNING - void declaration
     */
    private static Cookie constructLTPACookieObj(SingleSignonToken ssoToken, String ... removeAttributes) {
        byte[] ssoTokenBytes = ssoToken.getBytes();
        try {
            Token token = WebSecurityHelperImpl.recreateTokenFromBytes(ssoTokenBytes, removeAttributes);
            if (token != null) {
                ssoTokenBytes = token.getBytes();
            }
        }
        catch (InvalidTokenException token) {
            FFDCFilter.processException((Throwable)token, (String)"com.ibm.ws.webcontainer.security.internal.WebSecurityHelperImpl", (String)"154", null, (Object[])new Object[]{ssoToken, removeAttributes});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("Token is not valid" + e.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
        catch (TokenExpiredException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.webcontainer.security.internal.WebSecurityHelperImpl", (String)"159", null, (Object[])new Object[]{ssoToken, removeAttributes});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Token is expired" + e.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
        return WebSecurityHelperImpl.createCookie(ssoTokenBytes);
    }

    private static Token recreateTokenFromBytes(byte[] ssoToken, String ... removeAttributes) throws InvalidTokenException, TokenExpiredException {
        Token token = null;
        TokenManager tokenManager = (TokenManager)tokenManagerRef.getService();
        if (tokenManager != null) {
            byte[] credToken = AuthenticationHelper.copyCredToken((byte[])ssoToken);
            token = removeAttributes != null ? tokenManager.recreateTokenFromBytes(credToken, removeAttributes) : tokenManager.recreateTokenFromBytes(credToken, new String[0]);
        }
        return token;
    }

    private static Cookie createCookie(byte[] ssoTokenBytes) {
        String ssoCookieString = Base64Coder.base64EncodeToString((byte[])ssoTokenBytes);
        Cookie cookie = new Cookie(webAppSecConfig.getSSOCookieName(), ssoCookieString);
        return cookie;
    }

    static Cookie getLTPACookie(Subject subject, String ... removeAttributes) throws Exception {
        Cookie ltpaCookie = null;
        SingleSignonToken ssoToken = null;
        Set<SingleSignonToken> ssoTokens = subject.getPrivateCredentials(SingleSignonToken.class);
        Iterator<SingleSignonToken> ssoTokensIterator = ssoTokens.iterator();
        if (ssoTokensIterator.hasNext()) {
            ssoToken = ssoTokensIterator.next();
            if (ssoTokensIterator.hasNext()) {
                throw new WSSecurityException("More than one ssotoken found in subject");
            }
        }
        if (ssoToken != null) {
            ltpaCookie = removeAttributes == null ? WebSecurityHelperImpl.constructLTPACookieObj(ssoToken) : WebSecurityHelperImpl.constructLTPACookieObj(ssoToken, removeAttributes);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No ssotoken found for this subject", (Object[])new Object[0]);
        }
        return ltpaCookie;
    }

    protected void setTokenManager(ServiceReference<TokenManager> ref) {
        tokenManagerRef.setReference(ref);
    }

    protected void unsetTokenManager(ServiceReference<TokenManager> ref) {
        tokenManagerRef.unsetReference(ref);
    }

    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        tokenManagerRef.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        tokenManagerRef.deactivate(cc);
    }
}

