/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.http.HttpUtils;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.utils.SocialUtil;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.util.EntityUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OAuthClientHttpUtil {
    private static final TraceComponent tc = Tr.register(OAuthClientHttpUtil.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    static OAuthClientHttpUtil instance = null;
    private HttpUtils httpUtils = new HttpUtils();
    static final long serialVersionUID = 3583811655787444195L;

    OAuthClientHttpUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @Sensitive
    public String extractTokensFromResponse(Map<String, Object> postResponseMap) throws SocialLoginException {
        if (postResponseMap == null) {
            return null;
        }
        HttpResponse response = (HttpResponse)postResponseMap.get("RESPONSEMAP_CODE");
        if (response == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"An HttpResponse object was not found in the map", (Object[])new Object[0]);
            }
            return null;
        }
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        try {
            return EntityUtils.toString((HttpEntity)entity);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.social.internal.utils.OAuthClientHttpUtil", (String)"82", (Object)this, (Object[])new Object[]{postResponseMap});
            throw new SocialLoginException("ERROR_PARSING_RESPONSE_ENTITY", (Exception)e, new Object[]{e.getLocalizedMessage()});
        }
    }

    HttpPost createPostMethod(String url, List<NameValuePair> commonHeaders) throws SocialLoginException {
        SocialUtil.validateEndpointWithQuery(url);
        return this.httpUtils.createHttpPostMethod(url, commonHeaders);
    }

    HttpGet createHttpGetMethod(String url, List<NameValuePair> commonHeaders) throws SocialLoginException {
        SocialUtil.validateEndpointWithQuery(url);
        return this.httpUtils.createHttpGetMethod(url, commonHeaders);
    }

    /*
     * WARNING - void declaration
     */
    HttpResponse executeRequest(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, HttpUriRequest httpUriRequest, boolean useJvmProps) throws SocialLoginException {
        HttpClient httpClient = this.createHTTPClient(sslSocketFactory, url, isHostnameVerification, useJvmProps);
        HttpResponse response = null;
        ClassLoader origCL = ThreadContextHelper.getContextClassLoader();
        ThreadContextHelper.setClassLoader((ClassLoader)this.getClass().getClassLoader());
        try {
            response = httpClient.execute(httpUriRequest);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.social.internal.utils.OAuthClientHttpUtil", (String)"109", (Object)this, (Object[])new Object[]{sslSocketFactory, url, isHostnameVerification, httpUriRequest, useJvmProps});
            throw new SocialLoginException("ERROR_EXECUTING_REQUEST", (Exception)e, new Object[]{url, e.getLocalizedMessage()});
        }
        finally {
            ThreadContextHelper.setClassLoader((ClassLoader)origCL);
        }
        return response;
    }

    /*
     * WARNING - void declaration
     */
    void verifyResponse(String url, HttpResponse response) throws SocialLoginException {
        String errorMsg;
        String statusInsert;
        block5: {
            if (response == null) {
                return;
            }
            StatusLine status = response.getStatusLine();
            if (status != null && status.getStatusCode() == 200) {
                return;
            }
            statusInsert = status == null ? null : status.getStatusCode() + " " + status.getReasonPhrase();
            errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"RESPONSE_STATUS_MISSING_OR_ERROR", (Object[])new Object[]{statusInsert});
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                try {
                    errorMsg = EntityUtils.toString((HttpEntity)entity).trim();
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.social.internal.utils.OAuthClientHttpUtil", (String)"131", (Object)this, (Object[])new Object[]{url, response});
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)("Caught error parsing HttpEntity: " + e), (Object[])new Object[0]);
                }
            }
        }
        throw new SocialLoginException("RESPONSE_STATUS_UNSUCCESSFUL", null, new Object[]{url, statusInsert, errorMsg});
    }

    public Map<String, Object> postToEndpoint(String url, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, String accessToken, SSLSocketFactory sslSocketFactory, List<NameValuePair> commonHeaders, boolean isHostnameVerification, String authMethod, boolean useJvmProps) throws SocialLoginException {
        SocialUtil.validateEndpointWithQuery(url);
        this.httpUtils.debugPostToEndPoint(url, params, baUsername, baPassword, accessToken, commonHeaders);
        HttpPost postMethod = this.createPostMethod(url, commonHeaders);
        postMethod = this.setPostParameters(postMethod, params);
        return this.commonEndpointInvocation((HttpUriRequest)postMethod, url, baUsername, baPassword, accessToken, sslSocketFactory, isHostnameVerification, authMethod, useJvmProps);
    }

    public Map<String, Object> getToEndpoint(String url, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, String accessToken, SSLSocketFactory sslSocketFactory, List<NameValuePair> commonHeaders, boolean isHostnameVerification, String authMethod, boolean useJvmProps) throws SocialLoginException {
        SocialUtil.validateEndpointWithQuery(url);
        this.httpUtils.debugPostToEndPoint(url, params, baUsername, baPassword, accessToken, commonHeaders);
        HttpGet getMethod = this.createHttpGetMethod(url, commonHeaders);
        if (params != null) {
            for (NameValuePair nvp : params) {
                getMethod.addHeader(nvp.getName(), nvp.getValue());
            }
        }
        return this.commonEndpointInvocation((HttpUriRequest)getMethod, url, baUsername, baPassword, accessToken, sslSocketFactory, isHostnameVerification, authMethod, useJvmProps);
    }

    Map<String, Object> postToIntrospectEndpoint(String url, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, String accessToken, SSLSocketFactory sslSocketFactory, List<NameValuePair> commonHeaders, boolean isHostnameVerification, String authMethod, boolean useJvmProps) throws SocialLoginException {
        return this.postToEndpoint(url, params, baUsername, baPassword, accessToken, sslSocketFactory, commonHeaders, isHostnameVerification, authMethod, useJvmProps);
    }

    HttpPost setPostParameters(HttpPost postMethod, @Sensitive List<NameValuePair> params) {
        block3: {
            try {
                if (params != null) {
                    postMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Object[] objectArray = new Object[2];
                objectArray[0] = postMethod;
                objectArray[1] = "<sensitive java.util.List>";
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.social.internal.utils.OAuthClientHttpUtil", (String)"203", (Object)this, (Object[])objectArray);
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"The default encoding is not supported; parameters might not be present in the request", (Object[])new Object[0]);
            }
        }
        return postMethod;
    }

    Map<String, Object> commonEndpointInvocation(HttpUriRequest httpUriRequest, String url, String baUsername, @Sensitive String baPassword, String accessToken, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, String authMethod, boolean useJvmProps) throws SocialLoginException {
        this.setAuthorizationHeader(baUsername, baPassword, accessToken, httpUriRequest, authMethod);
        HttpResponse response = this.executeRequest(sslSocketFactory, url, isHostnameVerification, httpUriRequest, useJvmProps);
        this.verifyResponse(url, response);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("RESPONSEMAP_CODE", response);
        result.put("RESPONSEMAP_METHOD", httpUriRequest);
        return result;
    }

    void setAuthorizationHeader(String baUsername, @Sensitive String baPassword, String accessToken, HttpUriRequest httpUriRequest, String authMethod) {
        if (accessToken != null) {
            httpUriRequest.addHeader("Authorization", "bearer " + accessToken);
            return;
        }
        if (authMethod != null && authMethod.equals("client_secret_basic")) {
            String userpass = baUsername + ":" + baPassword;
            String basicAuth = "Basic " + Base64Coder.base64Encode((String)userpass);
            httpUriRequest.addHeader("Authorization", basicAuth);
        }
    }

    public HttpClient createHTTPClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, boolean useJvmProps) {
        return this.httpUtils.createHttpClient(sslSocketFactory, url, isHostnameVerification, useJvmProps);
    }

    public HttpClient createHTTPClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, String baUser, @Sensitive String baPassword, boolean useJvmProps) {
        BasicCredentialsProvider credentialsProvider = this.httpUtils.createCredentialsProvider(baUser, baPassword);
        return this.httpUtils.createHttpClient(sslSocketFactory, url, isHostnameVerification, useJvmProps, credentialsProvider);
    }

    public static OAuthClientHttpUtil getInstance() {
        if (instance == null) {
            instance = new OAuthClientHttpUtil();
        }
        return instance;
    }
}

