/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.server.plugins;

import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.api.oauth20.token.OAuth20TokenCache;
import com.ibm.oauth.core.internal.oauth20.responsetype.impl.OAuth20ResponseTypeHandlerCodeImpl;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenFactory;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.oauth20.util.ConfigUtils;
import com.ibm.ws.security.openidconnect.server.plugins.IDTokenImpl;
import com.ibm.ws.security.openidconnect.server.plugins.OIDCProvidersConfig;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="log", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class OIDCResponseTypeHandlerCodeImpl
extends OAuth20ResponseTypeHandlerCodeImpl {
    private static final String CLASS = OIDCResponseTypeHandlerCodeImpl.class.getName();
    private static Logger log = Logger.getLogger(CLASS);
    static final long serialVersionUID = 8889796686178753858L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public OIDCResponseTypeHandlerCodeImpl() {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.security.openidconnect.server.plugins.OIDCResponseTypeHandlerCodeImpl", "<init>", new Object[0]);
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.security.openidconnect.server.plugins.OIDCResponseTypeHandlerCodeImpl", "<init>", (Object)this);
        }
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<OAuth20Token> buildTokensResponseType(AttributeList attributeList, OAuth20TokenFactory tokenFactory, String redirectUri) {
        String methodName = "buildTokensResponseType";
        log.entering(CLASS, methodName);
        List tokens = super.buildTokensResponseType(attributeList, tokenFactory, redirectUri);
        OAuth20Token code = (OAuth20Token)tokens.get(0);
        OidcServerConfig oidcServerConfig = OIDCProvidersConfig.getOidcServerConfigForOAuth20Provider(code.getComponentId());
        if (this.hasThirdPartyClaims(oidcServerConfig) || this.hasMediatorSPI()) {
            OAuth20TokenCache tokenCache = tokenFactory.getOAuth20ComponentInternal().getTokenCache();
            this.cacheThirdPartyIDToken(code, tokenCache);
        }
        log.exiting(CLASS, methodName);
        return tokens;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean hasThirdPartyClaims(OidcServerConfig oidcServerConfig) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.security.openidconnect.server.plugins.OIDCResponseTypeHandlerCodeImpl", "hasThirdPartyClaims", new Object[]{oidcServerConfig});
        }
        boolean bl = oidcServerConfig != null && !oidcServerConfig.getThirdPartyIDTokenClaims().isEmpty();
        if (log != null && log.isLoggable(Level.FINER)) {
            bl = bl;
            log.exiting("com.ibm.ws.security.openidconnect.server.plugins.OIDCResponseTypeHandlerCodeImpl", "hasThirdPartyClaims", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean hasMediatorSPI() {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.security.openidconnect.server.plugins.OIDCResponseTypeHandlerCodeImpl", "hasMediatorSPI", new Object[0]);
        }
        boolean bl = ConfigUtils.getIdTokenMediatorService().size() > 0;
        if (log != null && log.isLoggable(Level.FINER)) {
            bl = bl;
            log.exiting("com.ibm.ws.security.openidconnect.server.plugins.OIDCResponseTypeHandlerCodeImpl", "hasMediatorSPI", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void cacheThirdPartyIDToken(OAuth20Token code, OAuth20TokenCache tokenCache) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.security.openidconnect.server.plugins.OIDCResponseTypeHandlerCodeImpl", "cacheThirdPartyIDToken", new Object[]{code, tokenCache});
        }
        SubjectHelper subjectHelper = new SubjectHelper();
        Hashtable hashtableFromRunAsSubject = subjectHelper.getHashtableFromRunAsSubject();
        if (hashtableFromRunAsSubject != null) {
            String thirdPartyIdTokenId = "third_party_idtoken:" + code.getTokenString();
            String thirdPartyIdTokenString = (String)hashtableFromRunAsSubject.get("id_token");
            if (thirdPartyIdTokenString != null) {
                IDTokenImpl tokenCacheEntry = new IDTokenImpl(thirdPartyIdTokenId, thirdPartyIdTokenString, code.getComponentId(), code.getClientId(), code.getUsername(), code.getRedirectUri(), code.getStateId(), code.getScope(), code.getLifetimeSeconds(), null, "authorization_code");
                tokenCache.add(tokenCacheEntry.getId(), (OAuth20Token)tokenCacheEntry, tokenCacheEntry.getLifetimeSeconds());
            }
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.security.openidconnect.server.plugins.OIDCResponseTypeHandlerCodeImpl", "cacheThirdPartyIDToken");
        }
    }
}

