/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.server.plugins;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.server.plugins.ProviderInfo;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OIDCProvidersConfig {
    private static TraceComponent tc = Tr.register(OIDCProvidersConfig.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    private static final Map<String, OidcServerConfig> oidcServerConfigMap = Collections.synchronizedMap(new HashMap());
    private static boolean bOidcUpdated = false;
    private static Map<String, OidcServerConfig> oidcMap = Collections.synchronizedMap(new HashMap());
    static final long serialVersionUID = 6782301368920914622L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OidcServerConfig getOidcServerConfigForOAuth20Provider(String oauth20providerName) {
        OidcServerConfig oidcServerConfig = null;
        Map<String, OidcServerConfig> map = oidcServerConfigMap;
        synchronized (map) {
            if (bOidcUpdated) {
                oidcMap = OIDCProvidersConfig.checkDuplicateOAuthProvider(oidcServerConfigMap);
                bOidcUpdated = false;
            }
        }
        for (String key : oidcMap.keySet()) {
            OidcServerConfig entry = oidcMap.get(key);
            String providerName = entry.getOauthProviderName();
            if (!oauth20providerName.equals(providerName)) continue;
            oidcServerConfig = entry;
            break;
        }
        return oidcServerConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putOidcServerConfig(String providerId, OidcServerConfig oidcServerConfig) {
        Map<String, OidcServerConfig> map = oidcServerConfigMap;
        synchronized (map) {
            oidcServerConfigMap.put(providerId, oidcServerConfig);
            bOidcUpdated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeOidcServerConfig(String providerId) {
        Map<String, OidcServerConfig> map = oidcServerConfigMap;
        synchronized (map) {
            oidcServerConfigMap.remove(providerId);
            bOidcUpdated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<ProviderInfo> getProviderNames() {
        ArrayList<ProviderInfo> list = new ArrayList<ProviderInfo>();
        Map<String, OidcServerConfig> map = oidcServerConfigMap;
        synchronized (map) {
            for (String key : oidcServerConfigMap.keySet()) {
                String id = oidcServerConfigMap.get(key).getProviderId();
                String oauthId = oidcServerConfigMap.get(key).getOauthProviderName();
                list.add(new ProviderInfo(id, oauthId));
            }
        }
        return list;
    }

    public static HashMap<String, OidcServerConfig> checkDuplicateOAuthProvider(Map<String, OidcServerConfig> oidcServerConfigRef) {
        HashMap<String, OidcServerConfig> result = new HashMap<String, OidcServerConfig>();
        HashMap<String, String> mapProviderId = new HashMap<String, String>();
        HashMap<String, String> mapConfigId = new HashMap<String, String>();
        Set<String> configIDs = oidcServerConfigRef.keySet();
        for (String configId : configIDs) {
            String oldOidcProviderId;
            OidcServerConfig oidcServerConfig = oidcServerConfigRef.get(configId);
            String oidcProviderId = oidcServerConfig.getProviderId();
            String oauthProviderName = oidcServerConfig.getOauthProviderName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("oidcConfigId: " + oidcProviderId + " oauthProviderName: " + oauthProviderName), (Object[])new Object[0]);
            }
            if ((oldOidcProviderId = (String)mapProviderId.get(oauthProviderName)) != null) {
                String oldConfigId = (String)mapConfigId.get(oauthProviderName);
                result.remove(oldConfigId);
                continue;
            }
            mapProviderId.put(oauthProviderName, oidcProviderId);
            mapConfigId.put(oauthProviderName, configId);
            result.put(configId, oidcServerConfig);
        }
        return result;
    }
}

