/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.server.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HttpUtils {
    public static final String CT_APPLICATION_JSON = "application/json";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String PUBLIC = "public";
    public static final String PRIVATE = "private";
    public static final String MAX_AGE = "max-age";
    static final long serialVersionUID = -2997100186941279871L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static String getFullCtxServletPath(HttpServletRequest request) {
        StringBuffer fullCtxServletPath = new StringBuffer();
        fullCtxServletPath.append(request.getScheme());
        fullCtxServletPath.append("://");
        fullCtxServletPath.append(request.getServerName());
        if (request.getServerPort() != 80 && request.getServerPort() != 443) {
            fullCtxServletPath.append(":");
            fullCtxServletPath.append(request.getServerPort());
        }
        fullCtxServletPath.append(request.getContextPath());
        fullCtxServletPath.append(request.getServletPath());
        return fullCtxServletPath.toString();
    }

    public static String constructCacheControlHeaderWithMaxAge(boolean isPublic, String maxAge) {
        String type = isPublic ? PUBLIC : PRIVATE;
        String headerValue = String.format("%s, %s=%s", type, MAX_AGE, maxAge);
        return headerValue;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.openidconnect.server.internal.HttpUtils", HttpUtils.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    }
}

