/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.spi.store;

import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.ehcache.Cache;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.ResourceType;
import org.ehcache.core.spi.store.ConfigurationChangeSupport;
import org.ehcache.core.spi.store.events.StoreEventSource;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.resilience.StoreAccessException;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.PluralService;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;

public interface Store<K, V>
extends ConfigurationChangeSupport {
    public ValueHolder<V> get(K var1) throws StoreAccessException;

    public boolean containsKey(K var1) throws StoreAccessException;

    public PutStatus put(K var1, V var2) throws StoreAccessException;

    default public ValueHolder<V> getAndPut(K key, V value) throws StoreAccessException {
        return this.getAndCompute(key, (k, v) -> value);
    }

    public ValueHolder<V> putIfAbsent(K var1, V var2, Consumer<Boolean> var3) throws StoreAccessException;

    public boolean remove(K var1) throws StoreAccessException;

    default public ValueHolder<V> getAndRemove(K key) throws StoreAccessException {
        return this.getAndCompute(key, (k, v) -> null);
    }

    public RemoveStatus remove(K var1, V var2) throws StoreAccessException;

    public ValueHolder<V> replace(K var1, V var2) throws StoreAccessException;

    public ReplaceStatus replace(K var1, V var2, V var3) throws StoreAccessException;

    public void clear() throws StoreAccessException;

    public StoreEventSource<K, V> getStoreEventSource();

    public Iterator<Cache.Entry<K, ValueHolder<V>>> iterator();

    public ValueHolder<V> getAndCompute(K var1, BiFunction<? super K, ? super V, ? extends V> var2) throws StoreAccessException;

    public ValueHolder<V> computeAndGet(K var1, BiFunction<? super K, ? super V, ? extends V> var2, Supplier<Boolean> var3, Supplier<Boolean> var4) throws StoreAccessException;

    public ValueHolder<V> computeIfAbsent(K var1, Function<? super K, ? extends V> var2) throws StoreAccessException;

    public Map<K, ValueHolder<V>> bulkCompute(Set<? extends K> var1, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> var2) throws StoreAccessException;

    public Map<K, ValueHolder<V>> bulkCompute(Set<? extends K> var1, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> var2, Supplier<Boolean> var3) throws StoreAccessException;

    public Map<K, ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> var1, Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> var2) throws StoreAccessException;

    public static enum ReplaceStatus {
        HIT,
        MISS_PRESENT,
        MISS_NOT_PRESENT;

    }

    public static enum RemoveStatus {
        REMOVED,
        KEY_PRESENT,
        KEY_MISSING;

    }

    public static enum PutStatus {
        PUT,
        NOOP;

    }

    public static interface Iterator<T> {
        public boolean hasNext();

        public T next() throws StoreAccessException;
    }

    public static interface Configuration<K, V> {
        public Class<K> getKeyType();

        public Class<V> getValueType();

        public EvictionAdvisor<? super K, ? super V> getEvictionAdvisor();

        public ClassLoader getClassLoader();

        public ExpiryPolicy<? super K, ? super V> getExpiry();

        public ResourcePools getResourcePools();

        public Serializer<K> getKeySerializer();

        public Serializer<V> getValueSerializer();

        public int getDispatcherConcurrency();

        default public boolean isOperationStatisticsEnabled() {
            return true;
        }

        public CacheLoaderWriter<? super K, V> getCacheLoaderWriter();

        default public boolean useLoaderInAtomics() {
            return false;
        }
    }

    @PluralService
    public static interface Provider
    extends Service {
        public <K, V> Store<K, V> createStore(Configuration<K, V> var1, ServiceConfiguration<?, ?> ... var2);

        public void releaseStore(Store<?, ?> var1);

        public void initStore(Store<?, ?> var1);

        public int rank(Set<ResourceType<?>> var1, Collection<ServiceConfiguration<?, ?>> var2);
    }

    public static interface ValueHolder<V>
    extends Supplier<V> {
        public static final long NO_EXPIRE = -1L;

        public long creationTime();

        public long expirationTime();

        public boolean isExpired(long var1);

        public long lastAccessTime();

        public long getId();

        @Override
        @Nonnull
        public V get();
    }
}

