/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.util.GsonStrategies;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OidcOAuth20Util
extends OAuth20Util {
    static final String CLASS = OidcOAuth20Util.class.getName();
    static Logger _log = Logger.getLogger(CLASS);
    private static final TraceComponent tc = Tr.register(OidcOAuth20Util.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    public static final Gson GSON_RAW = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().addSerializationExclusionStrategy(GsonStrategies.BETA_STRATEGY).create();
    public static final Gson GSON_RAWEST = new GsonBuilder().create();
    static final long serialVersionUID = -1741261837048602331L;

    @Trivial
    public static boolean isNullEmpty(Enumeration<String> values) {
        if (values == null) {
            return true;
        }
        return !values.hasMoreElements();
    }

    @Trivial
    public static boolean isNullEmpty(String value) {
        return value == null || value.isEmpty();
    }

    @Trivial
    public static boolean isNullEmpty(String[] values) {
        return values == null || values.length == 0;
    }

    @Trivial
    public static boolean isNullEmpty(JsonArray valueArr) {
        return valueArr == null || valueArr.size() == 0;
    }

    public static JsonArray initJsonArray(String value) {
        JsonArray jsonArr = new JsonArray();
        jsonArr.add((JsonElement)new JsonPrimitive(value));
        return jsonArr;
    }

    public static JsonArray initJsonArray(String[] values) {
        JsonArray jsonArr = new JsonArray();
        if (!OidcOAuth20Util.isNullEmpty(values)) {
            for (String value : values) {
                jsonArr.add((JsonElement)new JsonPrimitive(value));
            }
        }
        return jsonArr;
    }

    @Trivial
    public static String[] getStringArray(JsonArray jsonArray) {
        if (OidcOAuth20Util.isNullEmpty(jsonArray)) {
            return new String[0];
        }
        String[] strArr = new String[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            strArr[i] = jsonArray.get(i).getAsString();
        }
        return strArr;
    }

    @Trivial
    public static String getSpaceDelimitedString(JsonArray jsonArray) {
        return OidcOAuth20Util.getSpaceDelimitedString(OidcOAuth20Util.getStringArray(jsonArray));
    }

    @Trivial
    public static String getSpaceDelimitedString(String[] strArr) {
        if (strArr == null || strArr.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strArr.length; ++i) {
            sb.append(strArr[i]);
            if (i == strArr.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static boolean jsonArrayContainsString(JsonArray jsonArray, String string) {
        return OidcOAuth20Util.jsonArrayContainsString(jsonArray, string, false);
    }

    public static boolean jsonArrayContainsString(JsonArray jsonArray, String string, boolean matchRegexp) {
        int i;
        if (OidcOAuth20Util.isNullEmpty(jsonArray) && !OidcOAuth20Util.isNullEmpty(string)) {
            return false;
        }
        for (i = 0; i < jsonArray.size(); ++i) {
            if (!jsonArray.get(i).getAsString().equals(string)) continue;
            return true;
        }
        if (!matchRegexp) {
            return false;
        }
        for (i = 0; i < jsonArray.size(); ++i) {
            String redirect = jsonArray.get(i).getAsString();
            if (!redirect.startsWith("regexp:")) continue;
            redirect = redirect.substring(7, redirect.length());
            redirect = redirect.replace('!', '\\');
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("regex check pattern: >" + redirect + "< against string: > " + string + "< match: " + Pattern.matches(redirect, string)), (Object[])new Object[0]);
            }
            try {
                if (!Pattern.matches(redirect, string)) continue;
                return true;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                FFDCFilter.processException((Throwable)patternSyntaxException, (String)"com.ibm.ws.security.oauth20.util.OidcOAuth20Util", (String)"160", null, (Object[])new Object[]{jsonArray, string, matchRegexp});
                Tr.error((TraceComponent)tc, (String)"regexp.evaluation.error", (Object[])new Object[]{redirect});
                continue;
            }
            catch (IllegalArgumentException pse) {
                FFDCFilter.processException((Throwable)pse, (String)"com.ibm.ws.security.oauth20.util.OidcOAuth20Util", (String)"165", null, (Object[])new Object[]{jsonArray, string, matchRegexp});
                Tr.error((TraceComponent)tc, (String)"regexp.evaluation.error", (Object[])new Object[]{redirect});
            }
        }
        return false;
    }

    public static boolean validateRedirectUris(JsonArray redirectUris, boolean allowRegexpRedirects) {
        if (OidcOAuth20Util.isNullEmpty(redirectUris)) {
            return true;
        }
        for (int i = 0; i < redirectUris.size(); ++i) {
            boolean result;
            String buf = redirectUris.get(i).getAsString();
            if (buf.startsWith("regexp:") && allowRegexpRedirects || (result = OidcOAuth20Util.validateRedirectUri(buf))) continue;
            return false;
        }
        return true;
    }

    @Sensitive
    public static JsonObject getJsonObj(@Sensitive Object object) {
        return new JsonParser().parse(GSON_RAW.toJson(object)).getAsJsonObject();
    }

    @Sensitive
    public static List<JsonObject> getListOfJsonObjects(@Sensitive JsonArray values) {
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        if (!OidcOAuth20Util.isNullEmpty(values)) {
            for (JsonElement jsonEle : values) {
                list.add(jsonEle.getAsJsonObject());
            }
        }
        return list;
    }

    @ManualTrace
    public static boolean isJwtToken(String accessTokenString) {
        String methodName = "isJwtToken";
        boolean result = false;
        if (!OidcOAuth20Util.isNullEmpty(accessTokenString) && accessTokenString.indexOf(".") >= 0) {
            result = true;
        }
        _log.exiting(CLASS, methodName, "" + result);
        return result;
    }
}

