/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.error.ErrorHandlerImpl;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.web.EndpointServices;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class EndpointServlet
extends HttpServlet {
    private static TraceComponent tc = Tr.register(EndpointServlet.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlWab20Messages");
    private transient EndpointServices endpointServices = null;
    private transient ServletContext servletContext = null;
    private transient BundleContext bundleContext = null;
    private transient ServiceReference<EndpointServices> endpointServicesRef = null;
    private static final long serialVersionUID = 1L;

    public void init() {
        this.servletContext = this.getServletContext();
        this.bundleContext = (BundleContext)this.servletContext.getAttribute("osgi-bundlecontext");
        this.endpointServicesRef = this.bundleContext.getServiceReference(EndpointServices.class);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("init:" + this.servletContext + "   " + this.bundleContext + "  " + this.endpointServicesRef), (Object[])new Object[0]);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SsoRequest samlRequest = (SsoRequest)request.getAttribute("Saml20Request");
        if (Constants.EndpointType.SAMLMETADATA.equals((Object)samlRequest.getType()) || Constants.EndpointType.SLO.equals((Object)samlRequest.getType()) || Constants.EndpointType.LOGOUT.equals((Object)samlRequest.getType())) {
            this.doPost(request, response);
        } else {
            if (tc.isDebugEnabled()) {
                String requestType = samlRequest != null && samlRequest.getType() != null ? samlRequest.getType().toString() : null;
                Tr.debug((TraceComponent)tc, (String)("doGet is not allowed for samlrequest of type: " + requestType + ", sending http500"), (Object[])new Object[0]);
            }
            response.sendError(500, "INTERNAL ERROR");
        }
    }

    @FFDCIgnore(value={SamlException.class})
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        EndpointServices samlEndpointServices = this.getSamlEndpointServices(response);
        try {
            if (samlEndpointServices != null) {
                samlEndpointServices.handleSamlRequest(request, response);
            }
        }
        catch (SamlException e) {
            ErrorHandlerImpl.getInstance().handleException(request, response, e);
        }
    }

    private EndpointServices getSamlEndpointServices(HttpServletResponse response) throws ServletException {
        if (this.endpointServicesRef != null) {
            this.endpointServices = (EndpointServices)this.bundleContext.getService(this.endpointServicesRef);
            if (this.endpointServices == null) {
                this.init();
                this.endpointServices = (EndpointServices)this.bundleContext.getService(this.endpointServicesRef);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getSamlEndpointServices:" + this.servletContext + "   " + this.bundleContext + " " + this.endpointServices), (Object[])new Object[0]);
        }
        if (this.endpointServices == null) {
            try {
                Tr.error((TraceComponent)tc, (String)"SAML20_OSGI_ENDPOINT_SERVICE_ERROR", (Object[])new Object[0]);
                response.sendError(500, "INTERNAL ERROR");
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.saml.sso20.web.EndpointServlet", (String)"109", (Object)((Object)this), (Object[])new Object[]{response});
            }
        }
        return this.endpointServices;
    }
}

