/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.parser.util;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.parser.util.HashBucket;
import com.ibm.ws.sip.parser.util.LRUBucket;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LRUStringCache {
    private static final LogMgr c_logger = Log.get(LRUStringCache.class);
    private final HashBucket[] _values;
    private LRUBucket _LRURoot;
    private LRUBucket _LRUTail;
    private int _size;
    private int _maxSize;
    private int _cacheHit;
    private int _cacheMiss;
    private int _cacheOverflow;
    private static volatile LRUStringCache c_singletonCache;
    private LRUBucket _freeLRUBucket;
    private final Lock m_lock;
    private static final boolean INTERN = true;
    private static final ThreadLocal<char[]> s_threadLocalCharArray;

    public LRUStringCache(int maxSize) {
        if (maxSize < 2) {
            maxSize = 2;
        }
        this._maxSize = maxSize;
        for (int arraySize = 1; arraySize < maxSize; arraySize <<= 1) {
        }
        this._values = new HashBucket[arraySize <<= 1];
        this.m_lock = new ReentrantLock();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "LRUStringCache", "Size: " + this._size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String get(char[] value, int offset, int count) {
        if (this.m_lock.tryLock()) {
            try {
                String string = this.unsafeGet(value, offset, count);
                return string;
            }
            finally {
                this.m_lock.unlock();
            }
        }
        return this.instantiate(value, offset, count);
    }

    private final String unsafeGet(char[] value, int offset, int count) {
        if (value == null || count <= 0 || offset < 0) {
            return "";
        }
        String rValue = null;
        int hash = this.calcHash(value, offset, count);
        int index = this.calcIndex(hash);
        if (this._values[index] != null) {
            rValue = this.searchValueInHashChain(index, value, offset, count);
        }
        if (rValue == null) {
            ++this._cacheMiss;
            rValue = this.create(hash, index, value, offset, count);
        }
        if (c_logger.isTraceDebugEnabled() && (this._cacheHit + this._cacheMiss) % this._maxSize == 0) {
            c_logger.traceDebug(this, "get", this.toString());
        }
        return rValue;
    }

    public final String get(byte[] byteArray, int offset, int count) {
        char[] charArray = s_threadLocalCharArray.get();
        if (charArray.length < count) {
            charArray = new char[count];
            s_threadLocalCharArray.set(charArray);
        }
        for (int i = 0; i < count; ++i) {
            byte b = byteArray[offset + i];
            charArray[i] = (char)b;
        }
        return this.get(charArray, 0, count);
    }

    private final String searchValueInHashChain(int index, char[] value, int offset, int count) {
        String rValue = null;
        HashBucket hBucket = this._values[index];
        while (hBucket != null && rValue == null) {
            String cachedVal = hBucket._value;
            boolean match = true;
            if (cachedVal.length() == count) {
                int off = offset;
                for (int i = 0; i < count; ++i) {
                    if (cachedVal.charAt(i) == value[off++]) continue;
                    match = false;
                    break;
                }
            } else {
                match = false;
            }
            if (match) {
                rValue = cachedVal;
                this.moveToTopOfLRUList(hBucket._LRUBucket);
                ++this._cacheHit;
                continue;
            }
            hBucket = hBucket._next;
        }
        return rValue;
    }

    private final void moveToTopOfLRUList(LRUBucket current) {
        LRUBucket next;
        if (current == this._LRURoot) {
            return;
        }
        LRUBucket previous = current._prev;
        previous._next = next = current._next;
        if (next != null) {
            next._prev = previous;
        }
        if (current == this._LRUTail) {
            this._LRUTail = previous;
            this._LRUTail._next = null;
        }
        current._next = this._LRURoot;
        this._LRURoot._prev = current;
        this._LRURoot = current;
        current._prev = null;
    }

    private final String create(int hash, int index, char[] value, int offset, int count) {
        LRUBucket lruBucket;
        HashBucket hBucket;
        String rValue = this.instantiate(value, offset, count);
        if (this._freeLRUBucket != null) {
            hBucket = this._freeLRUBucket._hashBucket;
            hBucket._hash = hash;
            hBucket._value = rValue;
            hBucket._next = null;
            lruBucket = this._freeLRUBucket;
            lruBucket._next = null;
            lruBucket._prev = null;
            this._freeLRUBucket = null;
        } else {
            hBucket = new HashBucket(hash, rValue);
            hBucket._LRUBucket = lruBucket = new LRUBucket(hBucket);
        }
        if (this._values[index] != null) {
            hBucket._next = this._values[index];
        }
        this._values[index] = hBucket;
        ++this._size;
        if (null == this._LRURoot) {
            this._LRURoot = lruBucket;
            this._LRUTail = lruBucket;
        } else {
            lruBucket._next = this._LRURoot;
            this._LRURoot._prev = lruBucket;
            this._LRURoot = lruBucket;
        }
        if (this._size > this._maxSize) {
            this.removeLeastUsedValue();
        }
        return rValue;
    }

    private final String instantiate(char[] value, int offset, int count) {
        String string = new String(value, offset, count);
        string = string.intern();
        return string;
    }

    private final void removeLeastUsedValue() {
        LRUBucket leastUsedB = this._LRUTail;
        leastUsedB._prev._next = null;
        this._LRUTail = leastUsedB._prev;
        leastUsedB._prev = null;
        int leastUsedIndex = this.calcIndex(leastUsedB._hashBucket._hash);
        HashBucket currentHBucket = this._values[leastUsedIndex];
        if (currentHBucket == leastUsedB._hashBucket) {
            this._values[leastUsedIndex] = null;
        } else {
            while (currentHBucket != null) {
                HashBucket prevBucket = currentHBucket;
                currentHBucket = currentHBucket._next;
                if (currentHBucket != leastUsedB._hashBucket) continue;
                prevBucket._next = currentHBucket._next;
                ++this._cacheOverflow;
                break;
            }
        }
        --this._size;
        this._freeLRUBucket = leastUsedB;
    }

    public void dumpLRUList() {
        LRUBucket temp = this._LRURoot;
        System.out.print("\nRoot ");
        while (temp != null) {
            System.out.print(" -> " + temp._hashBucket._value);
            temp = temp._next;
        }
        System.out.print("\nTail: ");
        temp = this._LRUTail;
        while (temp != null) {
            System.out.print(" -> " + temp._hashBucket._value);
            temp = temp._prev;
        }
        System.out.println("");
    }

    public void dumpHash() {
        System.out.println("Cache contents: ");
        for (int i = 0; i < this._values.length; ++i) {
            if (this._values[i] == null) continue;
            System.out.print(i + " : ");
            HashBucket hBucket = this._values[i];
            while (hBucket != null) {
                System.out.print(" -> " + hBucket._value);
                hBucket = hBucket._next;
            }
            System.out.println("");
        }
    }

    private final int calcIndex(int hash) {
        return hash & this._values.length - 1;
    }

    private final int calcHash(char[] value, int offset, int count) {
        int h = 0;
        int off = offset;
        char[] val = value;
        int len = count;
        for (int i = 0; i < len; ++i) {
            h = 31 * h + val[off++];
        }
        return h;
    }

    public String toString() {
        double hitPercent = (double)((int)(1000.0 * (double)this._cacheHit / (double)(this._cacheHit + this._cacheMiss))) / 10.0;
        StringBuffer buffer = new StringBuffer();
        buffer.append("Cache size: ");
        buffer.append(this._size);
        buffer.append('/');
        buffer.append(this._maxSize);
        buffer.append(" ,");
        buffer.append("Cache Hit: ");
        buffer.append(this._cacheHit);
        buffer.append(" ");
        buffer.append(hitPercent);
        buffer.append("%");
        buffer.append(" ,");
        buffer.append("Cache Overflow: ");
        buffer.append(this._cacheOverflow);
        return buffer.toString();
    }

    public int getHits() {
        return this._cacheHit;
    }

    public int getMisses() {
        return this._cacheMiss;
    }

    public int getSize() {
        return this._size;
    }

    public static final LRUStringCache getInstance() {
        if (null == c_singletonCache) {
            int size = ApplicationProperties.getProperties().getInt("lruStringChacheSize");
            c_singletonCache = new LRUStringCache(size);
        }
        return c_singletonCache;
    }

    static {
        s_threadLocalCharArray = new ThreadLocal<char[]>(){

            @Override
            protected char[] initialValue() {
                return new char[64];
            }
        };
    }
}

