/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.pkce;

import com.ibm.oauth.core.api.error.oauth20.InvalidGrantException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.pkce.PkceMethodPlain;
import com.ibm.ws.security.oauth20.pkce.PkceMethodS256;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class ProofKeyForCodeExchangeMethod {
    public static final Set<String> SUPPORTED_CODE_CHALLENGE_METHODS;
    static final long serialVersionUID = -3575166691589345191L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static ProofKeyForCodeExchangeMethod getInstance(String challengeMethod) {
        if (challengeMethod == null || challengeMethod.isEmpty()) {
            return null;
        }
        if (PkceMethodS256.CHALLENGE_METHOD.equals(challengeMethod)) {
            return new PkceMethodS256();
        }
        if (PkceMethodPlain.CHALLENGE_METHOD.equals(challengeMethod)) {
            return new PkceMethodPlain();
        }
        return null;
    }

    public static boolean isValidCodeChallengeMethod(String codeChallengeMethod) {
        if (codeChallengeMethod == null) {
            return false;
        }
        return SUPPORTED_CODE_CHALLENGE_METHODS.contains(codeChallengeMethod);
    }

    public abstract String getCodeChallengeMethod();

    public abstract String generateCodeChallenge(String var1);

    public abstract void validate(String var1, String var2) throws InvalidGrantException;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.pkce.ProofKeyForCodeExchangeMethod", ProofKeyForCodeExchangeMethod.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
        HashSet<String> supportedCodeChallengeMethods = new HashSet<String>();
        supportedCodeChallengeMethods.add("plain");
        supportedCodeChallengeMethods.add("S256");
        SUPPORTED_CODE_CHALLENGE_METHODS = Collections.unmodifiableSet(supportedCodeChallengeMethods);
    }
}

