/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.service.util.ServiceCaller;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.internal.config.McpConfiguration;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCErrorCode;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCException;
import io.openliberty.mcp.internal.requests.CancellationImpl;
import io.openliberty.mcp.internal.requests.ExecutionRequestId;
import io.openliberty.mcp.messaging.Cancellation;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@ApplicationScoped
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class McpRequestTracker {
    private static final TraceComponent tc = Tr.register(McpRequestTracker.class, (String)"MCP", (String)"io.openliberty.mcp.internal.resources.CWMCM");
    private ConcurrentMap<ExecutionRequestId, CancellationImpl> ongoingRequests = new ConcurrentHashMap<ExecutionRequestId, CancellationImpl>();
    private final ConcurrentMap<String, Set<ExecutionRequestId>> sessionToRequestIds = new ConcurrentHashMap<String, Set<ExecutionRequestId>>();
    private static final ServiceCaller<McpConfiguration> mcpConfigService = new ServiceCaller(McpRequestTracker.class, McpConfiguration.class);
    static final long serialVersionUID = 1125186329979076874L;

    public McpRequestTracker() {
        this.ongoingRequests = new ConcurrentHashMap<ExecutionRequestId, CancellationImpl>();
    }

    public void deregisterOngoingRequest(ExecutionRequestId id) {
        this.ongoingRequests.remove(id);
    }

    public void registerOngoingRequest(ExecutionRequestId requestId, CancellationImpl cancellation) {
        CancellationImpl previous = this.ongoingRequests.putIfAbsent(requestId, cancellation);
        if (previous != null) {
            throw new JSONRPCException(JSONRPCErrorCode.INVALID_PARAMS, Tr.formatMessage((TraceComponent)tc, (String)"CWMCM0008E.invalid.request.params", (Object[])new Object[]{requestId.id()}));
        }
    }

    public boolean isOngoingRequest(ExecutionRequestId id) {
        return this.ongoingRequests.containsKey(id);
    }

    public Cancellation getOngoingRequestCancellation(ExecutionRequestId id) {
        return (Cancellation)this.ongoingRequests.get(id);
    }

    public void cancelSessionRequests(String sessionId) {
        Boolean stateless = mcpConfigService.run(McpConfiguration::isStateless).orElse(false);
        if (Boolean.TRUE.equals(stateless)) {
            return;
        }
        Set requests = (Set)this.sessionToRequestIds.remove(sessionId);
        if (requests == null) {
            return;
        }
        for (ExecutionRequestId id : requests) {
            Cancellation cancellation = (Cancellation)this.ongoingRequests.remove(id);
            if (!(cancellation instanceof CancellationImpl)) continue;
            CancellationImpl impl = (CancellationImpl)cancellation;
            impl.cancel(Optional.of("Session cancelled"));
        }
    }
}

