/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.conn;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.UnsupportedSchemeException;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.nio.conn.CPool;
import org.apache.http.impl.nio.conn.CPoolEntry;
import org.apache.http.impl.nio.conn.CPoolProxy;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.conn.ManagedNHttpClientConnection;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NHttpConnectionFactory;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.pool.NIOConnFactory;
import org.apache.http.nio.pool.SocketAddressResolver;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.pool.PoolEntry;
import org.apache.http.pool.PoolStats;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

/*
 * Exception performing whole class analysis ignored.
 */
@Contract(threading=ThreadingBehavior.SAFE)
public class PoolingNHttpClientConnectionManager
implements NHttpClientConnectionManager,
ConnPoolControl<HttpRoute> {
    private final Log log = LogFactory.getLog(this.getClass());
    static final String IOSESSION_FACTORY_REGISTRY = "http.iosession-factory-registry";
    private final ConnectingIOReactor ioreactor;
    private final ConfigData configData;
    private final CPool pool;
    private final Registry<SchemeIOSessionStrategy> iosessionFactoryRegistry;

    private static Registry<SchemeIOSessionStrategy> getDefaultRegistry() {
        return RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)SSLIOSessionStrategy.getDefaultStrategy()).build();
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor ioreactor) {
        this(ioreactor, PoolingNHttpClientConnectionManager.getDefaultRegistry());
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor ioreactor, Registry<SchemeIOSessionStrategy> iosessionFactoryRegistry) {
        this(ioreactor, null, iosessionFactoryRegistry, (DnsResolver)null);
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor ioreactor, NHttpConnectionFactory<ManagedNHttpClientConnection> connFactory, DnsResolver dnsResolver) {
        this(ioreactor, connFactory, PoolingNHttpClientConnectionManager.getDefaultRegistry(), dnsResolver);
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor ioreactor, NHttpConnectionFactory<ManagedNHttpClientConnection> connFactory, SocketAddressResolver<HttpRoute> socketAddressResolver) {
        this(ioreactor, connFactory, PoolingNHttpClientConnectionManager.getDefaultRegistry(), socketAddressResolver);
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor ioreactor, NHttpConnectionFactory<ManagedNHttpClientConnection> connFactory) {
        this(ioreactor, connFactory, PoolingNHttpClientConnectionManager.getDefaultRegistry(), (DnsResolver)null);
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor ioreactor, NHttpConnectionFactory<ManagedNHttpClientConnection> connFactory, Registry<SchemeIOSessionStrategy> iosessionFactoryRegistry) {
        this(ioreactor, connFactory, iosessionFactoryRegistry, (DnsResolver)null);
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor ioreactor, NHttpConnectionFactory<ManagedNHttpClientConnection> connFactory, Registry<SchemeIOSessionStrategy> iosessionFactoryRegistry, DnsResolver dnsResolver) {
        this(ioreactor, connFactory, iosessionFactoryRegistry, null, dnsResolver, -1L, TimeUnit.MILLISECONDS);
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor ioreactor, NHttpConnectionFactory<ManagedNHttpClientConnection> connFactory, Registry<SchemeIOSessionStrategy> iosessionFactoryRegistry, SocketAddressResolver<HttpRoute> socketAddressResolver) {
        this(ioreactor, connFactory, iosessionFactoryRegistry, socketAddressResolver, -1L, TimeUnit.MILLISECONDS);
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor ioreactor, NHttpConnectionFactory<ManagedNHttpClientConnection> connFactory, Registry<SchemeIOSessionStrategy> iosessionFactoryRegistry, SchemePortResolver schemePortResolver, DnsResolver dnsResolver, long timeToLive, TimeUnit tunit) {
        this(ioreactor, connFactory, iosessionFactoryRegistry, (SocketAddressResolver)new InternalAddressResolver(schemePortResolver, dnsResolver), timeToLive, tunit);
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor ioreactor, NHttpConnectionFactory<ManagedNHttpClientConnection> connFactory, Registry<SchemeIOSessionStrategy> iosessionFactoryRegistry, SocketAddressResolver<HttpRoute> socketAddressResolver, long timeToLive, TimeUnit tunit) {
        Args.notNull((Object)ioreactor, (String)"I/O reactor");
        Args.notNull(iosessionFactoryRegistry, (String)"I/O session factory registry");
        Args.notNull(socketAddressResolver, (String)"Socket address resolver");
        this.ioreactor = ioreactor;
        this.configData = new ConfigData();
        this.pool = new CPool(ioreactor, (NIOConnFactory)new InternalConnectionFactory(this.configData, connFactory), socketAddressResolver, 2, 20, timeToLive, tunit != null ? tunit : TimeUnit.MILLISECONDS);
        this.iosessionFactoryRegistry = iosessionFactoryRegistry;
    }

    PoolingNHttpClientConnectionManager(ConnectingIOReactor ioreactor, CPool pool, Registry<SchemeIOSessionStrategy> iosessionFactoryRegistry) {
        this.ioreactor = ioreactor;
        this.configData = new ConfigData();
        this.pool = pool;
        this.iosessionFactoryRegistry = iosessionFactoryRegistry;
    }

    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    public void execute(IOEventDispatch eventDispatch) throws IOException {
        this.ioreactor.execute(eventDispatch);
    }

    public void shutdown(long waitMs) throws IOException {
        this.log.debug((Object)"Connection manager is shutting down");
        this.pool.shutdown(waitMs);
        this.log.debug((Object)"Connection manager shut down");
    }

    public void shutdown() throws IOException {
        this.log.debug((Object)"Connection manager is shutting down");
        this.pool.shutdown(2000L);
        this.log.debug((Object)"Connection manager shut down");
    }

    private String format(HttpRoute route, Object state) {
        StringBuilder buf = new StringBuilder();
        buf.append("[route: ").append(route).append("]");
        if (state != null) {
            buf.append("[state: ").append(state).append("]");
        }
        return buf.toString();
    }

    private String formatStats(HttpRoute route) {
        StringBuilder buf = new StringBuilder();
        PoolStats totals = this.pool.getTotalStats();
        PoolStats stats = this.pool.getStats((Object)route);
        buf.append("[total kept alive: ").append(totals.getAvailable()).append("; ");
        buf.append("route allocated: ").append(stats.getLeased() + stats.getAvailable());
        buf.append(" of ").append(stats.getMax()).append("; ");
        buf.append("total allocated: ").append(totals.getLeased() + totals.getAvailable());
        buf.append(" of ").append(totals.getMax()).append("]");
        return buf.toString();
    }

    private String format(CPoolEntry entry) {
        StringBuilder buf = new StringBuilder();
        buf.append("[id: ").append(entry.getId()).append("]");
        buf.append("[route: ").append(entry.getRoute()).append("]");
        Object state = entry.getState();
        if (state != null) {
            buf.append("[state: ").append(state).append("]");
        }
        return buf.toString();
    }

    public Future<NHttpClientConnection> requestConnection(HttpRoute route, Object state, long connectTimeout, long leaseTimeout, TimeUnit tunit, FutureCallback<NHttpClientConnection> callback) {
        Args.notNull((Object)route, (String)"HTTP route");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Connection request: " + this.format(route, state) + this.formatStats(route)));
        }
        BasicFuture resultFuture = new BasicFuture(callback);
        HttpHost host = route.getProxyHost() != null ? route.getProxyHost() : route.getTargetHost();
        SchemeIOSessionStrategy sf = (SchemeIOSessionStrategy)this.iosessionFactoryRegistry.lookup(host.getSchemeName());
        if (sf == null) {
            resultFuture.failed((Exception)((Object)new UnsupportedSchemeException(host.getSchemeName() + " protocol is not supported")));
            return resultFuture;
        }
        Future leaseFuture = this.pool.lease((Object)route, state, connectTimeout, leaseTimeout, tunit != null ? tunit : TimeUnit.MILLISECONDS, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(NHttpClientConnection managedConn, Object state, long keepalive, TimeUnit tunit) {
        Args.notNull((Object)managedConn, (String)"Managed connection");
        NHttpClientConnection nHttpClientConnection = managedConn;
        synchronized (nHttpClientConnection) {
            NHttpClientConnection conn;
            CPoolEntry entry;
            block9: {
                entry = CPoolProxy.detach((NHttpClientConnection)managedConn);
                if (entry == null) {
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Releasing connection: " + this.format(entry) + this.formatStats((HttpRoute)entry.getRoute())));
                }
                conn = (NHttpClientConnection)entry.getConnection();
                try {
                    if (!conn.isOpen()) break block9;
                    entry.setState(state);
                    entry.updateExpiry(keepalive, tunit != null ? tunit : TimeUnit.MILLISECONDS);
                    if (!this.log.isDebugEnabled()) break block9;
                    String s = keepalive > 0L ? "for " + (double)keepalive / 1000.0 + " seconds" : "indefinitely";
                    this.log.debug((Object)("Connection " + this.format(entry) + " can be kept alive " + s));
                }
                catch (Throwable throwable) {
                    this.pool.release((PoolEntry)entry, conn.isOpen() && entry.isRouteComplete());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Connection released: " + this.format(entry) + this.formatStats((HttpRoute)entry.getRoute())));
                    }
                    throw throwable;
                }
            }
            this.pool.release((PoolEntry)entry, conn.isOpen() && entry.isRouteComplete());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Connection released: " + this.format(entry) + this.formatStats((HttpRoute)entry.getRoute())));
            }
        }
    }

    private Lookup<SchemeIOSessionStrategy> getIOSessionFactoryRegistry(HttpContext context) {
        Lookup reg = (Lookup)context.getAttribute("http.iosession-factory-registry");
        if (reg == null) {
            reg = this.iosessionFactoryRegistry;
        }
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRoute(NHttpClientConnection managedConn, HttpRoute route, HttpContext context) throws IOException {
        Args.notNull((Object)managedConn, (String)"Managed connection");
        Args.notNull((Object)route, (String)"HTTP route");
        HttpHost host = route.getProxyHost() != null ? route.getProxyHost() : route.getTargetHost();
        Lookup reg = this.getIOSessionFactoryRegistry(context);
        SchemeIOSessionStrategy sf = (SchemeIOSessionStrategy)reg.lookup(host.getSchemeName());
        if (sf == null) {
            throw new UnsupportedSchemeException(host.getSchemeName() + " protocol is not supported");
        }
        if (sf.isLayeringRequired()) {
            NHttpClientConnection nHttpClientConnection = managedConn;
            synchronized (nHttpClientConnection) {
                CPoolEntry entry = CPoolProxy.getPoolEntry((NHttpClientConnection)managedConn);
                ManagedNHttpClientConnection conn = (ManagedNHttpClientConnection)entry.getConnection();
                IOSession ioSession = conn.getIOSession();
                IOSession currentSession = sf.upgrade(host, ioSession);
                conn.bind(currentSession);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade(NHttpClientConnection managedConn, HttpRoute route, HttpContext context) throws IOException {
        Args.notNull((Object)managedConn, (String)"Managed connection");
        Args.notNull((Object)route, (String)"HTTP route");
        HttpHost host = route.getTargetHost();
        Lookup reg = this.getIOSessionFactoryRegistry(context);
        SchemeIOSessionStrategy sf = (SchemeIOSessionStrategy)reg.lookup(host.getSchemeName());
        if (sf == null) {
            throw new UnsupportedSchemeException(host.getSchemeName() + " protocol is not supported");
        }
        if (!sf.isLayeringRequired()) {
            throw new UnsupportedSchemeException(host.getSchemeName() + " protocol does not support connection upgrade");
        }
        NHttpClientConnection nHttpClientConnection = managedConn;
        synchronized (nHttpClientConnection) {
            CPoolEntry entry = CPoolProxy.getPoolEntry((NHttpClientConnection)managedConn);
            ManagedNHttpClientConnection conn = (ManagedNHttpClientConnection)entry.getConnection();
            IOSession currentSession = sf.upgrade(host, conn.getIOSession());
            conn.bind(currentSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void routeComplete(NHttpClientConnection managedConn, HttpRoute route, HttpContext context) {
        Args.notNull((Object)managedConn, (String)"Managed connection");
        Args.notNull((Object)route, (String)"HTTP route");
        NHttpClientConnection nHttpClientConnection = managedConn;
        synchronized (nHttpClientConnection) {
            CPoolEntry entry = CPoolProxy.getPoolEntry((NHttpClientConnection)managedConn);
            entry.markRouteComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRouteComplete(NHttpClientConnection managedConn) {
        Args.notNull((Object)managedConn, (String)"Managed connection");
        NHttpClientConnection nHttpClientConnection = managedConn;
        synchronized (nHttpClientConnection) {
            CPoolEntry entry = CPoolProxy.getPoolEntry((NHttpClientConnection)managedConn);
            return entry.isRouteComplete();
        }
    }

    public void closeIdleConnections(long idleTimeout, TimeUnit tunit) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Closing connections idle longer than " + idleTimeout + " " + (Object)((Object)tunit)));
        }
        this.pool.closeIdle(idleTimeout, tunit);
    }

    public void closeExpiredConnections() {
        this.log.debug((Object)"Closing expired connections");
        this.pool.closeExpired();
    }

    public void validatePendingRequests() {
        this.log.debug((Object)"Validating pending requests");
        this.pool.validatePendingRequests();
    }

    public int getMaxTotal() {
        return this.pool.getMaxTotal();
    }

    public void setMaxTotal(int max) {
        this.pool.setMaxTotal(max);
    }

    public int getDefaultMaxPerRoute() {
        return this.pool.getDefaultMaxPerRoute();
    }

    public void setDefaultMaxPerRoute(int max) {
        this.pool.setDefaultMaxPerRoute(max);
    }

    public int getMaxPerRoute(HttpRoute route) {
        return this.pool.getMaxPerRoute((Object)route);
    }

    public void setMaxPerRoute(HttpRoute route, int max) {
        this.pool.setMaxPerRoute((Object)route, max);
    }

    public PoolStats getTotalStats() {
        return this.pool.getTotalStats();
    }

    public PoolStats getStats(HttpRoute route) {
        return this.pool.getStats((Object)route);
    }

    public Set<HttpRoute> getRoutes() {
        return this.pool.getRoutes();
    }

    public ConnectionConfig getDefaultConnectionConfig() {
        return this.configData.getDefaultConnectionConfig();
    }

    public void setDefaultConnectionConfig(ConnectionConfig defaultConnectionConfig) {
        this.configData.setDefaultConnectionConfig(defaultConnectionConfig);
    }

    public ConnectionConfig getConnectionConfig(HttpHost host) {
        return this.configData.getConnectionConfig(host);
    }

    public void setConnectionConfig(HttpHost host, ConnectionConfig connectionConfig) {
        this.configData.setConnectionConfig(host, connectionConfig);
    }

    static /* synthetic */ Log access$000(PoolingNHttpClientConnectionManager x0) {
        return x0.log;
    }

    static /* synthetic */ String access$100(PoolingNHttpClientConnectionManager x0, CPoolEntry x1) {
        return x0.format(x1);
    }

    static /* synthetic */ String access$200(PoolingNHttpClientConnectionManager x0, HttpRoute x1) {
        return x0.formatStats(x1);
    }

    static /* synthetic */ CPool access$300(PoolingNHttpClientConnectionManager x0) {
        return x0.pool;
    }
}

