/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.coordinator.internal;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.ActionStatus;
import com.arjuna.ats.arjuna.coordinator.abstractrecord.RecordTypeManager;
import com.arjuna.ats.arjuna.coordinator.abstractrecord.RecordTypeMap;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import io.narayana.lra.coordinator.domain.model.Transaction;
import io.narayana.lra.coordinator.domain.service.LRAService;
import io.narayana.lra.coordinator.internal.RecoveringLRA;
import io.narayana.lra.logging.LRALogger;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import java.util.function.Consumer;
import org.eclipse.microprofile.lra.annotation.LRAStatus;

public class LRARecoveryModule
implements RecoveryModule {
    private LRAService lraService;
    private String _transactionType = Transaction.getType();
    private Vector _transactionUidVector = null;
    private static RecoveryStore _recoveryStore = null;
    private TransactionStatusConnectionManager _transactionStatusConnectionMgr;

    public LRARecoveryModule(LRAService lraService) {
        this.lraService = lraService;
        if (_recoveryStore == null) {
            _recoveryStore = StoreManager.getRecoveryStore();
        }
        this._transactionStatusConnectionMgr = new TransactionStatusConnectionManager();
        RecordTypeManager.manager().add((RecordTypeMap)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void periodicWorkFirstPass() {
        InputObjectState aa_uids = new InputObjectState();
        if (this.getUids(aa_uids)) {
            this._transactionUidVector = this.processTransactions(aa_uids);
        }
    }

    public void periodicWorkSecondPass() {
        if (LRALogger.logger.isDebugEnabled()) {
            LRALogger.logger.debug((Object)"LRARecoveryModule: second pass");
        }
        this.processTransactionsStatus();
    }

    private void doRecoverTransaction(Uid recoverUid) {
        block7: {
            int theStatus = this._transactionStatusConnectionMgr.getTransactionStatus(this._transactionType, recoverUid);
            try {
                RecoveringLRA lra = new RecoveringLRA(this.lraService, recoverUid, theStatus);
                String Status2 = ActionStatus.stringForm((int)theStatus);
                boolean inFlight = lra.isActive();
                LRAStatus lraStatus = lra.getLRAStatus();
                if (LRAStatus.FailedToCancel.equals((Object)lraStatus) || LRAStatus.FailedToClose.equals((Object)lraStatus)) {
                    return;
                }
                if (!this.lraService.hasTransaction(lra.getId())) {
                    this.lraService.addTransaction((Transaction)lra);
                }
                if (LRALogger.logger.isDebugEnabled()) {
                    LRALogger.logger.debug((Object)("LRARecoverModule: transaction type is " + this._transactionType + " uid is " + recoverUid.toString() + "\n ActionStatus is " + Status2 + " in flight is " + inFlight));
                }
                if (!inFlight && lra.hasPendingActions()) {
                    lra.replayPhase2();
                    if (!lra.isRecovering() && this.lraService != null) {
                        this.lraService.finished((Transaction)lra, false);
                    }
                }
            }
            catch (Exception e) {
                if (!LRALogger.logger.isInfoEnabled()) break block7;
                LRALogger.logger.infof("LRARecoverModule: Error '%s' while recovering LRA record %s", (Object)e.getMessage(), (Object)recoverUid.fileStringForm());
            }
        }
    }

    private Vector<Uid> processTransactions(InputObjectState uids) {
        Vector<Uid> uidVector = new Vector<Uid>();
        if (LRALogger.logger.isDebugEnabled()) {
            LRALogger.logger.debugf("LRARecoverModule: processing transaction type %s", (Object)this._transactionType);
        }
        Consumer<Uid> uidUnpacker = uidVector::addElement;
        this.forEach(uids, uidUnpacker);
        return uidVector;
    }

    private void processTransactionsStatus() {
        if (this._transactionUidVector != null) {
            Enumeration transactionUidEnum = this._transactionUidVector.elements();
            while (transactionUidEnum.hasMoreElements()) {
                Uid currentUid = (Uid)transactionUidEnum.nextElement();
                try {
                    if (_recoveryStore.currentState(currentUid, this._transactionType) == -1) continue;
                    this.doRecoverTransaction(currentUid);
                }
                catch (ObjectStoreException e) {
                    if (LRALogger.logger.isTraceEnabled()) {
                        LRALogger.logger.tracef((Throwable)e, "LRARecoverModule: Object store exception '%s' while reading the current state of LRA record %s:", (Object)e.getMessage(), (Object)currentUid.fileStringForm());
                        continue;
                    }
                    if (!LRALogger.logger.isInfoEnabled()) continue;
                    LRALogger.logger.infof("LRARecoverModule: Object store exception '%s' while reading the current state of LRA record %s", (Object)e.getMessage(), (Object)currentUid.fileStringForm());
                }
            }
        }
    }

    public void getRecoveringLRAs(Map<URI, Transaction> lras) {
        this.periodicWorkFirstPass();
        if (this._transactionUidVector != null) {
            Enumeration transactionUidEnum = this._transactionUidVector.elements();
            while (transactionUidEnum.hasMoreElements()) {
                int status;
                Uid currentUid = (Uid)transactionUidEnum.nextElement();
                RecoveringLRA lra = new RecoveringLRA(this.lraService, currentUid, status = this._transactionStatusConnectionMgr.getTransactionStatus(this._transactionType, currentUid));
                if (lra.isActivated()) {
                    lras.put(lra.getId(), (Transaction)lra);
                    continue;
                }
                LRALogger.logger.infof("LRARecoverModule: failed to activate LRA record %s", (Object)currentUid.fileStringForm());
            }
        }
    }

    public boolean removeCommitted(Uid lraUid) {
        try {
            return _recoveryStore.remove_committed(lraUid, this._transactionType);
        }
        catch (ObjectStoreException e) {
            if (LRALogger.logger.isTraceEnabled()) {
                LRALogger.logger.tracef((Throwable)e, "LRARecoveryModule: Object store exception '%s' while removing LRA record %s", (Object)e.getMessage(), (Object)lraUid.fileStringForm());
            } else if (LRALogger.logger.isInfoEnabled()) {
                LRALogger.logger.infof("LRARecoveryModule: Object store exception '%s' while removing LRA record %s", (Object)e.getMessage(), (Object)lraUid.fileStringForm());
            }
            return false;
        }
    }

    public void getFailedLRAs(Map<URI, Transaction> lras) {
        InputObjectState aa_uids = new InputObjectState();
        Consumer<Uid> failedLRACreator = uid -> {
            Transaction lra = new Transaction(this.lraService, new Uid(uid));
            lra.activate();
            LRAStatus status = lra.getLRAStatus();
            if (LRAStatus.FailedToCancel.equals((Object)status) || LRAStatus.FailedToClose.equals((Object)status)) {
                lras.put(lra.getId(), lra);
            }
        };
        if (this.getUids(aa_uids)) {
            this.forEach(aa_uids, failedLRACreator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getUids(InputObjectState aa_uids) {
        LRARecoveryModule lRARecoveryModule = this;
        synchronized (lRARecoveryModule) {
            try {
                return _recoveryStore.allObjUids(this._transactionType, aa_uids);
            }
            catch (ObjectStoreException e) {
                if (LRALogger.logger.isTraceEnabled()) {
                    LRALogger.logger.tracef((Throwable)e, "LRARecoverModule: Object store exception %s while unpacking records of type %s", (Object)e.getMessage(), (Object)this._transactionType);
                } else if (LRALogger.logger.isInfoEnabled()) {
                    LRALogger.logger.infof("LRARecoverModule: Object store exception %s while unpacking records of type %s", (Object)e.getMessage(), (Object)this._transactionType);
                }
                return false;
            }
        }
    }

    private void forEach(InputObjectState uids, Consumer<Uid> consumer) {
        try {
            while (true) {
                Uid uid;
                if ((uid = new Uid(uids.unpackBytes())).equals(Uid.nullUid())) {
                    return;
                }
                consumer.accept(uid);
            }
        }
        catch (IOException e) {
            if (LRALogger.logger.isTraceEnabled()) {
                LRALogger.logger.tracef((Throwable)e, "LRARecoverModule: Object store exception %s while unpacking a record of type %s", (Object)e.getMessage(), (Object)this._transactionType);
            } else if (LRALogger.logger.isInfoEnabled()) {
                LRALogger.logger.infof("LRARecoverModule: Object store exception %s while unpacking a record of type: %s", (Object)e.getMessage());
            }
            return;
        }
    }
}

