/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.ExtendedRecoveryModule;
import com.arjuna.ats.arjuna.recovery.RecoveryDriver;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.recovery.Service;
import com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;

public class WorkerService
implements Service {
    private PeriodicRecovery _periodicRecovery = null;
    private boolean doWait = false;

    public WorkerService(PeriodicRecovery pr) {
        this._periodicRecovery = pr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(InputStream is, OutputStream os) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        PrintWriter out = new PrintWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
        try {
            String request = in.readLine();
            if ("PING".equals(request)) {
                out.println("PONG");
            } else if (RecoveryDriver.isScan((String)request)) {
                Object object;
                boolean isAsync = RecoveryDriver.isAsyncScan((String)request);
                boolean anyProblems = false;
                if (!isAsync) {
                    object = this;
                    synchronized (object) {
                        this.doWait = true;
                    }
                }
                this._periodicRecovery.wakeUp();
                tsLogger.i18NLogger.info_recovery_WorkerService_3();
                if (!isAsync) {
                    object = this;
                    synchronized (object) {
                        if (this.doWait && this._periodicRecovery.getMode() != PeriodicRecovery.Mode.TERMINATED) {
                            try {
                                this.wait();
                            }
                            catch (Exception ex) {
                                if (tsLogger.logger.isTraceEnabled()) {
                                    tsLogger.logger.trace((Object)"Waiting for recovery scan to complete finished with an exception", (Throwable)ex);
                                }
                                tsLogger.i18NLogger.info_recovery_WorkerService_4();
                            }
                        }
                    }
                }
                if (RecoveryDriver.isVerboseScan((String)request)) {
                    for (RecoveryModule recoveryModule : RecoveryManager.manager().getModules()) {
                        if (!(recoveryModule instanceof ExtendedRecoveryModule)) continue;
                        if (((ExtendedRecoveryModule)recoveryModule).isPeriodicWorkSuccessful()) break;
                        anyProblems = true;
                        break;
                    }
                }
                out.println(anyProblems ? "ERROR" : "DONE");
            } else {
                out.println("ERROR");
            }
            out.flush();
        }
        catch (IOException ioe) {
            tsLogger.i18NLogger.warn_recovery_WorkerService_2(ioe);
        }
        catch (Exception ex) {
            tsLogger.i18NLogger.warn_recovery_WorkerService_1((Throwable)ex);
        }
    }

    public synchronized void notifyDone() {
        try {
            this.notifyAll();
            this.doWait = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

