/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.utility.tasks;

import com.ibm.ws.jbatch.utility.JBatchUtilityTask;
import com.ibm.ws.jbatch.utility.tasks.BaseCommandTask;
import com.ibm.ws.jbatch.utility.utils.ConsoleWrapper;
import com.ibm.ws.jbatch.utility.utils.StringUtils;
import com.ibm.ws.jbatch.utility.utils.TaskList;
import java.io.PrintStream;

public class HelpTask
extends BaseCommandTask {
    private final TaskList tasks;

    public HelpTask(String scriptName, TaskList tasks) {
        super("help", scriptName);
        this.tasks = tasks;
    }

    @Override
    public String getTaskHelp() {
        return this.joinMsgs(this.getUsage("help.usage.options", this.scriptName, this.getTaskName()), this.getDesc("help.desc"));
    }

    public String getScriptUsage() {
        StringBuffer scriptUsage = new StringBuffer(this.NL);
        scriptUsage.append(this.getMessage("usage", this.scriptName));
        scriptUsage.append(" {");
        scriptUsage.append(StringUtils.join(this.tasks.getTaskNames(), "|"));
        scriptUsage.append("} [options]");
        scriptUsage.append(this.NL);
        return scriptUsage.toString();
    }

    public String getTaskUsage(JBatchUtilityTask task) {
        StringBuffer taskUsage = new StringBuffer(this.NL);
        taskUsage.append(this.NL);
        taskUsage.append(task.getTaskHelp());
        return taskUsage.toString();
    }

    private String verboseHelp() {
        StringBuffer verboseHelp = new StringBuffer(this.getScriptUsage());
        if (this.tasks.size() > 0) {
            verboseHelp.append(this.NL);
            verboseHelp.append(this.getOption("global.actions", new Object[0]));
            verboseHelp.append(this.NL);
            for (JBatchUtilityTask task : this.tasks) {
                verboseHelp.append(this.NL);
                verboseHelp.append("    ");
                verboseHelp.append(task.getTaskName());
                verboseHelp.append(this.NL);
                verboseHelp.append(task.getTaskDescription());
                verboseHelp.append(this.NL);
            }
            verboseHelp.append(this.NL);
            verboseHelp.append(this.getOption("global.options", new Object[0]));
            verboseHelp.append(this.NL);
            verboseHelp.append(this.getOption("global.options.statement", new Object[0]));
        }
        return verboseHelp.toString();
    }

    private String taskHelp(JBatchUtilityTask task) {
        return task.getTaskHelp() + this.NL;
    }

    @Override
    public int handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) {
        if (args.length == 1) {
            stdout.println(this.verboseHelp());
        } else {
            JBatchUtilityTask task = this.tasks.forName(args[1]);
            if (task == null) {
                stderr.println(this.NL + this.getMessage("task.unknown", args[1]) + this.NL);
            } else {
                stdout.println(this.taskHelp(task));
            }
        }
        return 0;
    }
}

