/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.wim.scim20.exceptions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.scim20.model.ErrorImpl;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class SCIMException
extends Exception {
    private static final long serialVersionUID = -1591160795632407017L;
    private final Integer httpCode;
    private final String scimType;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SCIMException(int httpCode, String scimType, String message) {
        this(httpCode, scimType, message, null);
    }

    public SCIMException(int httpCode, String scimType, String message, Throwable cause) {
        super(message, cause);
        this.httpCode = httpCode;
        this.scimType = scimType;
    }

    public Integer getHttpCode() {
        return this.httpCode;
    }

    public String getScimType() {
        return this.scimType;
    }

    public String asJson() throws JsonProcessingException {
        ErrorImpl error = new ErrorImpl();
        error.setScimType(this.scimType);
        error.setDetail(this.getMessage());
        error.setStatus(this.httpCode);
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)error);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.websphere.security.wim.scim20.exceptions.SCIMException", SCIMException.class, null, null);
    }
}

