/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.async;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.webcontainer.srt.SRTServletRequestThreadData;
import com.ibm.ws.webcontainer31.async.AsyncContext31Impl;
import com.ibm.ws.webcontainer31.async.ThreadContextManager;
import com.ibm.ws.webcontainer31.srt.SRTInputStream31;
import com.ibm.wsspi.channelfw.InterChannelCallback;
import com.ibm.wsspi.channelfw.VirtualConnection;
import java.io.IOException;
import javax.servlet.AsyncContext;

public class AsyncReadCallback
implements InterChannelCallback {
    private static final TraceComponent tc = Tr.register(AsyncReadCallback.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    private SRTInputStream31 in;
    private ThreadContextManager threadContextManager;
    private SRTServletRequestThreadData _requestDataAsyncReadCallbackThread;
    private boolean pushedThreadContext = false;
    private boolean onErrorDriven = false;
    private boolean onAllDataReadCalled = false;
    private AsyncContext context;

    public AsyncReadCallback(SRTInputStream31 in, ThreadContextManager tcm, AsyncContext context) {
        this.in = in;
        this.threadContextManager = tcm;
        this._requestDataAsyncReadCallbackThread = SRTServletRequestThreadData.getInstance();
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IOException.class})
    public void complete(VirtualConnection vc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"complete", (Object[])new Object[]{vc});
        }
        if (null == vc) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"complete");
            }
            return;
        }
        Object object = this.in.getCompleteLockObj();
        synchronized (object) {
            block39: {
                this.in.setAsyncReadOutstanding(false);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Calling user's ReadListener onDataAvailable : " + this.in.getReadListener() + " " + this.context), (Object[])new Object[0]);
                }
                SRTServletRequestThreadData.getInstance().init(this._requestDataAsyncReadCallbackThread);
                boolean localPushedThreadContext = false;
                try {
                    if (!this.pushedThreadContext) {
                        this.threadContextManager.pushContextData();
                        this.pushedThreadContext = true;
                        localPushedThreadContext = true;
                    }
                    try {
                        this.in.getReadListener().onDataAvailable();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Returned from user's ReadListener onDataAvailable : " + this.in.getReadListener() + " " + this.context), (Object[])new Object[0]);
                        }
                    }
                    catch (Throwable onDataAvailableException) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Exception occurred during ReadListener.onDataAvailable : " + onDataAvailableException + ", " + this.in.getReadListener()), (Object[])new Object[0]);
                        }
                        this.error(vc, onDataAvailableException);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"complete");
                        }
                        if (localPushedThreadContext) {
                            this.pushedThreadContext = false;
                            this.threadContextManager.popContextData();
                        }
                        return;
                    }
                    if (this.in.getReadListener() != null) {
                        AsyncContext31Impl context31 = (AsyncContext31Impl)this.context;
                        if (context31.isComplete() || context31.isCompletePending()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"AsyncContext.complete() already invoked; skipping onAllDataRead()");
                            }
                            return;
                        }
                        if (this.in.isFinished()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Message is fully read, calling ReadListener onAllDataRead : " + this.in.getReadListener() + " " + this.context), (Object[])new Object[0]);
                            }
                            try {
                                if (!this.onAllDataReadCalled) {
                                    this.onAllDataReadCalled = true;
                                    this.in.getReadListener().onAllDataRead();
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("Returned from user's ReadListener onAllDataRead : " + this.in.getReadListener() + " " + this.context), (Object[])new Object[0]);
                                    }
                                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Returned from user's ReadListener onAllDataRead onAllDataRead has already been called, do nothing here. " + this.context), (Object[])new Object[0]);
                                }
                                break block39;
                            }
                            catch (Throwable onAllDataReadException) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Exception occurred during ReadListener.onAllDataRead : " + onAllDataReadException + ", " + this.in.getReadListener() + " " + this.context), (Object[])new Object[0]);
                                }
                                this.error(vc, onAllDataReadException);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"complete");
                                }
                                if (localPushedThreadContext) {
                                    this.pushedThreadContext = false;
                                    this.threadContextManager.popContextData();
                                }
                                return;
                            }
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Data hasn't been fully read yet. There should be an outstanding read at this point : " + this.in.getReadListener()), (Object[])new Object[0]);
                        }
                        if (!this.onErrorDriven) {
                            this.in.prepareAsyncReadListener();
                        }
                        break block39;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ReadListener is not set , stream must be closed, cannot call onAllDataRead()", (Object[])new Object[0]);
                    }
                }
                finally {
                    if (localPushedThreadContext) {
                        this.pushedThreadContext = false;
                        this.threadContextManager.popContextData();
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(VirtualConnection vc, Throwable t) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Calling user's ReadListener onError : " + this.in.getReadListener()), (Object[])new Object[0]);
        }
        this.onErrorDriven = true;
        Exception e = null;
        SRTServletRequestThreadData.getInstance().init(this._requestDataAsyncReadCallbackThread);
        Object object = this.in.getCompleteLockObj();
        synchronized (object) {
            block15: {
                boolean localPushedThreadContext = false;
                try {
                    if (!this.pushedThreadContext) {
                        this.threadContextManager.pushContextData();
                        this.pushedThreadContext = true;
                        localPushedThreadContext = true;
                    }
                    if (this.in.getReadListener() != null) {
                        this.in.setAsyncReadOutstanding(false);
                        try {
                            this.in.getReadListener().onError(t);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Returned from user's ReadListener onError : " + this.in.getReadListener()), (Object[])new Object[0]);
                            }
                        }
                        catch (Exception onErrorException) {
                            e = onErrorException;
                        }
                        if (e != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Exception occurred during ReadListener.onError : " + e + ", " + this.in.getReadListener()), (Object[])new Object[0]);
                        }
                        break block15;
                    }
                    if (t != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception occurred during ReadListener and error cannot handle : " + t.getMessage() + ", " + this.in.getReadListener()), (Object[])new Object[0]);
                    }
                }
                finally {
                    if (localPushedThreadContext) {
                        this.pushedThreadContext = false;
                        this.threadContextManager.popContextData();
                    }
                }
            }
        }
    }
}

