/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import org.eclipse.microprofile.openapi.models.servers.ServerVariables;

public class ServerVariablesValidator
extends TypeValidator<ServerVariables> {
    private static final TraceComponent tc = Tr.register(ServerVariablesValidator.class);
    private static final ServerVariablesValidator INSTANCE = new ServerVariablesValidator();

    public static ServerVariablesValidator getInstance() {
        return INSTANCE;
    }

    private ServerVariablesValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, ServerVariables t) {
        if (t != null) {
            boolean mapContainsInvalidKey = false;
            for (String k : t.keySet()) {
                if (k == null || k.isEmpty()) {
                    mapContainsInvalidKey = true;
                    continue;
                }
                if (t.get((Object)k) != null) continue;
                String message = Tr.formatMessage((TraceComponent)tc, (String)"nullValueInMap", (Object[])new Object[]{k});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
            if (mapContainsInvalidKey) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"nullOrEmptyKeyInMap", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
        }
    }
}

