/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.ClientEndpointConfigCopyFactory;
import com.ibm.ws.wsoc.WebSocketFactoryImpl;
import com.ibm.ws.wsoc.external.WebSocketFactory;
import com.ibm.ws.wsoc.link.LinkWriteFactory;
import com.ibm.ws.wsoc.link.LinkWriteFactory10;
import com.ibm.ws.wsoc.outbound.HttpRequestorFactory;
import com.ibm.ws.wsoc.outbound.HttpRequestorWsoc10FactoryImpl;
import com.ibm.ws.wsoc.servercontainer.ServletContainerFactory;
import com.ibm.ws.wsoc.servercontainer.v10.ServerContainerImplFactory10;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Properties;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebSocketVersionServiceManager {
    private static final TraceComponent tc = Tr.register(WebSocketVersionServiceManager.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    private static final AtomicServiceReference<CHFWBundle> cfwBundleRef = new AtomicServiceReference("chfwBundle");
    private static final AtomicServiceReference<WebSocketFactory> websocketFactoryServiceRef = new AtomicServiceReference("websocketFactoryService");
    private static final AtomicServiceReference<ServletContainerFactory> servletContainerFactorySRRef = new AtomicServiceReference("servletContainerFactoryService");
    private static final AtomicServiceReference<LinkWriteFactory> linkWriteFactorySRRef = new AtomicServiceReference("linkWriteFactoryService");
    private static final WebSocketFactory DEFAULT_WEBSOCKET_FACTORY = new WebSocketFactoryImpl();
    private static final ServletContainerFactory DEFAULT_SERVLET_CONTAINER_FACTORY = new ServerContainerImplFactory10();
    private static final LinkWriteFactory DEFAULT_SERVLET_LINK_WRITE_FACTORY = new LinkWriteFactory10();
    private static final AtomicServiceReference<HttpRequestorFactory> httpRequestorFactoryServiceRef = new AtomicServiceReference("httpRequestorFactoryService");
    private static final AtomicServiceReference<ClientEndpointConfigCopyFactory> clientEndpointConfigCopyFactoryServiceRef = new AtomicServiceReference("clientEndpointConfigCopyFactoryService");
    private static final HttpRequestorFactory DEFAULT_HTTPREQUESTOR_FACTORY = new HttpRequestorWsoc10FactoryImpl();
    public static String LOADED_SPEC_LEVEL = WebSocketVersionServiceManager.loadWsocVersion();
    private static String DEFAULT_VERSION = "1.0";
    static final long serialVersionUID = -238614214240962506L;

    protected synchronized void activate(ComponentContext context) {
        cfwBundleRef.activate(context);
        websocketFactoryServiceRef.activate(context);
        servletContainerFactorySRRef.activate(context);
        httpRequestorFactoryServiceRef.activate(context);
        clientEndpointConfigCopyFactoryServiceRef.activate(context);
        linkWriteFactorySRRef.activate(context);
    }

    protected synchronized void deactivate(ComponentContext context) {
        cfwBundleRef.deactivate(context);
        websocketFactoryServiceRef.deactivate(context);
        servletContainerFactorySRRef.deactivate(context);
        httpRequestorFactoryServiceRef.deactivate(context);
        clientEndpointConfigCopyFactoryServiceRef.deactivate(context);
        linkWriteFactorySRRef.deactivate(context);
    }

    protected void setChfwBundle(ServiceReference<CHFWBundle> service) {
        cfwBundleRef.setReference(service);
    }

    protected void unsetChfwBundle(ServiceReference<CHFWBundle> service) {
        cfwBundleRef.unsetReference(service);
    }

    public static ChannelFramework getCfw() {
        return ((CHFWBundle)cfwBundleRef.getServiceWithException()).getFramework();
    }

    public static WsByteBufferPoolManager getBufferPoolManager() {
        if (cfwBundleRef.getService() != null) {
            return ((CHFWBundle)cfwBundleRef.getService()).getBufferManager();
        }
        return ChannelFrameworkFactory.getBufferManager();
    }

    public static WebSocketFactory getWebSocketFactory() {
        WebSocketFactory webSocketFactory = (WebSocketFactory)websocketFactoryServiceRef.getService();
        if (webSocketFactory == null) {
            return DEFAULT_WEBSOCKET_FACTORY;
        }
        return webSocketFactory;
    }

    protected static ServletContainerFactory getServerContainerExtFactory() {
        ServletContainerFactory servletContainerFactory = (ServletContainerFactory)servletContainerFactorySRRef.getService();
        if (servletContainerFactory != null) {
            return servletContainerFactory;
        }
        return DEFAULT_SERVLET_CONTAINER_FACTORY;
    }

    protected void setServletContainerFactoryService(ServiceReference<ServletContainerFactory> service) {
        servletContainerFactorySRRef.setReference(service);
    }

    protected void unsetServletContainerFactoryService(ServiceReference<ServletContainerFactory> service) {
        servletContainerFactorySRRef.unsetReference(service);
    }

    protected static LinkWriteFactory getLinkWriteFactory() {
        LinkWriteFactory linkWriteFactory = (LinkWriteFactory)linkWriteFactorySRRef.getService();
        if (linkWriteFactory != null) {
            return linkWriteFactory;
        }
        return DEFAULT_SERVLET_LINK_WRITE_FACTORY;
    }

    protected void setLinkWriteFactoryService(ServiceReference<LinkWriteFactory> service) {
        linkWriteFactorySRRef.setReference(service);
    }

    protected void unsetLinkWriteFactoryService(ServiceReference<LinkWriteFactory> service) {
        linkWriteFactorySRRef.unsetReference(service);
    }

    protected void setWebsocketFactoryService(ServiceReference<WebSocketFactory> ref) {
        websocketFactoryServiceRef.setReference(ref);
    }

    protected void unsetWebsocketFactoryService(ServiceReference<WebSocketFactory> ref) {
        websocketFactoryServiceRef.unsetReference(ref);
    }

    public static HttpRequestorFactory getHttpRequestorFactory() {
        HttpRequestorFactory httpRequestorFactory = (HttpRequestorFactory)httpRequestorFactoryServiceRef.getService();
        if (httpRequestorFactory == null) {
            return DEFAULT_HTTPREQUESTOR_FACTORY;
        }
        return httpRequestorFactory;
    }

    protected void setHttpRequestorFactoryService(ServiceReference<HttpRequestorFactory> ref) {
        httpRequestorFactoryServiceRef.setReference(ref);
    }

    protected void unsetHttpRequestorFactoryService(ServiceReference<HttpRequestorFactory> ref) {
        httpRequestorFactoryServiceRef.unsetReference(ref);
    }

    public static ClientEndpointConfigCopyFactory getClientEndpointConfigCopyFactory() {
        ClientEndpointConfigCopyFactory clientEndpointConfigCopyFactory = (ClientEndpointConfigCopyFactory)clientEndpointConfigCopyFactoryServiceRef.getService();
        return clientEndpointConfigCopyFactory;
    }

    protected void setClientEndpointConfigCopyFactoryService(ServiceReference<ClientEndpointConfigCopyFactory> ref) {
        clientEndpointConfigCopyFactoryServiceRef.setReference(ref);
    }

    protected void unsetClientEndpointConfigCopyFactoryService(ServiceReference<ClientEndpointConfigCopyFactory> ref) {
        clientEndpointConfigCopyFactoryServiceRef.unsetReference(ref);
    }

    /*
     * Unable to fully structure code
     */
    private static synchronized String loadWsocVersion() {
        block13: {
            block11: {
                block12: {
                    input = WebSocketVersionServiceManager.class.getClassLoader().getResourceAsStream("io/openliberty/wsoc/speclevel/wsocSpecLevel.properties");
                    if (input == null) break block11;
                    prop = new Properties();
                    prop.load(input);
                    version = prop.getProperty("version");
                    Tr.debug((TraceComponent)WebSocketVersionServiceManager.tc, (String)("Loading WebSocket version " + version + " from wsocSpecLevel.propertie"), (Object[])new Object[0]);
                    var3_6 = version;
                    if (input == null) break block12;
                    input.close();
                }
                return var3_6;
            }
            try {
                if (WebSocketVersionServiceManager.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)WebSocketVersionServiceManager.tc, (String)"InputStream was null for wsocSpecLevel.properties", (Object[])new Object[0]);
                }
                ** if (input == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    input.close();
                }
lbl-1000:
                // 2 sources

                {
                    break block13;
                }
                {
                    catch (Throwable var1_3) {
                        FFDCFilter.processException((Throwable)var1_3, (String)"com.ibm.ws.wsoc.WebSocketVersionServiceManager", (String)"222", null, (Object[])new Object[0]);
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable var2_5) {
                                FFDCFilter.processException((Throwable)var2_5, (String)"com.ibm.ws.wsoc.WebSocketVersionServiceManager", (String)"222", null, (Object[])new Object[0]);
                                var1_3.addSuppressed(var2_5);
                            }
                        }
                        throw var1_3;
                    }
                }
            }
            catch (Exception input) {
                FFDCFilter.processException((Throwable)input, (String)"com.ibm.ws.wsoc.WebSocketVersionServiceManager", (String)"236", null, (Object[])new Object[0]);
                if (!WebSocketVersionServiceManager.tc.isDebugEnabled()) break block13;
                Tr.debug((TraceComponent)WebSocketVersionServiceManager.tc, (String)("Exception occured: " + ex.getCause()), (Object[])new Object[0]);
            }
        }
        Tr.error((TraceComponent)WebSocketVersionServiceManager.tc, (String)"wsoc.feature.not.loaded.correctly", (Object[])new Object[0]);
        return WebSocketVersionServiceManager.DEFAULT_VERSION;
    }

    public static boolean isWsoc21OrHigher() {
        return Double.parseDouble(LOADED_SPEC_LEVEL) >= 2.1;
    }

    public static boolean isWsoc22OrHigher() {
        return Double.parseDouble(LOADED_SPEC_LEVEL) >= 2.2;
    }
}

