/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc.external;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.ServiceManager;
import com.ibm.ws.wsoc.WebSocketContainerManager;
import com.ibm.ws.wsoc.injection.InjectionProvider;
import com.ibm.ws.wsoc.injection.InjectionProvider12;
import com.ibm.ws.wsoc.outbound.ClientConnector;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.Extension;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebSocketContainerExt
implements WebSocketContainer {
    private static final TraceComponent tc = Tr.register(WebSocketContainerExt.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    long defaultAsyncSendTimeout = 0L;
    long defaultMaxSessionIdleTimeout = -1L;
    int defaultMaxBinaryMessageBufferSize = -1;
    int defaultMaxTextMessageBufferSize = -1;
    static final long serialVersionUID = 5874031882803516089L;

    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncSendTimeout;
    }

    public void setAsyncSendTimeout(long timeoutmillis) {
        this.defaultAsyncSendTimeout = timeoutmillis;
    }

    public long getDefaultMaxSessionIdleTimeout() {
        return this.defaultMaxSessionIdleTimeout;
    }

    public void setDefaultMaxSessionIdleTimeout(long timeout) {
        this.defaultMaxSessionIdleTimeout = timeout;
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.defaultMaxBinaryMessageBufferSize;
    }

    public void setDefaultMaxBinaryMessageBufferSize(int max) {
        this.defaultMaxBinaryMessageBufferSize = max;
    }

    public int getDefaultMaxTextMessageBufferSize() {
        return this.defaultMaxTextMessageBufferSize;
    }

    public void setDefaultMaxTextMessageBufferSize(int max) {
        this.defaultMaxTextMessageBufferSize = max;
    }

    public Session connectToServer(Object clazz, URI path) throws DeploymentException, IOException {
        if (clazz == null || path == null) {
            throw new IllegalArgumentException();
        }
        ClientConnector x = new ClientConnector();
        return x.connectAnnotatedClass(clazz, path, this);
    }

    /*
     * WARNING - void declaration
     */
    public Session connectToServer(Class<?> clazz, URI path) throws DeploymentException, IOException {
        if (clazz == null || path == null) {
            throw new IllegalArgumentException();
        }
        Object theObject = null;
        ClientConnector x = new ClientConnector();
        try {
            theObject = this.getEndpointInstance(clazz);
        }
        catch (DeploymentException deploymentException) {
            void e;
            FFDCFilter.processException((Throwable)deploymentException, (String)"com.ibm.ws.wsoc.external.WebSocketContainerExt", (String)"118", (Object)this, (Object[])new Object[]{clazz, path});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"client.connection.error", (Object[])new Object[]{clazz.toString(), e.getMessage()});
            Tr.error((TraceComponent)tc, (String)"client.connection.error", (Object[])new Object[]{clazz.toString(), e.getMessage()});
            throw new DeploymentException(msg, (Throwable)e);
        }
        return x.connectAnnotatedClass(theObject, path, this);
    }

    public Session connectToServer(Endpoint endpoint, ClientEndpointConfig endpointConfig, URI path) throws DeploymentException, IOException {
        if (endpoint == null || path == null) {
            throw new IllegalArgumentException();
        }
        ClientConnector x = new ClientConnector();
        return x.connectClass(endpoint, path, endpointConfig, this);
    }

    /*
     * WARNING - void declaration
     */
    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig endpointConfig, URI path) throws DeploymentException, IOException {
        Endpoint theObject = null;
        if (endpointClass == null || path == null) {
            throw new IllegalArgumentException();
        }
        if (!Endpoint.class.isAssignableFrom(endpointClass)) {
            DeploymentException e = new DeploymentException("Class " + endpointClass.getName() + " does not extend Endpoint");
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"client.invalid.endpointclass", (Object[])new Object[]{endpointClass.toString(), e.getMessage()});
            Tr.error((TraceComponent)tc, (String)"client.invalid.endpointclass", (Object[])new Object[]{endpointClass.toString(), e.getMessage()});
            throw new DeploymentException(msg, (Throwable)e);
        }
        ClientConnector x = new ClientConnector();
        try {
            theObject = this.getEndpointInstance(endpointClass);
        }
        catch (DeploymentException msg) {
            void e;
            FFDCFilter.processException((Throwable)msg, (String)"com.ibm.ws.wsoc.external.WebSocketContainerExt", (String)"167", (Object)this, (Object[])new Object[]{endpointClass, endpointConfig, path});
            String msg2 = Tr.formatMessage((TraceComponent)tc, (String)"client.connection.error", (Object[])new Object[]{endpointClass.toString(), e.getMessage()});
            Tr.error((TraceComponent)tc, (String)"client.connection.error", (Object[])new Object[]{endpointClass.toString(), e.getMessage()});
            throw new DeploymentException(msg2, (Throwable)e);
        }
        return x.connectClass(theObject, path, endpointConfig, this);
    }

    public Set<Extension> getInstalledExtensions() {
        return Collections.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    public <T> T getEndpointInstance(Class<T> endpointClass) throws DeploymentException {
        try {
            InjectionProvider12 ip12 = ServiceManager.getInjectionProvider12();
            if (ip12 != null) {
                ConcurrentHashMap map = WebSocketContainerManager.getRef().getEndpointMap();
                T ep = ip12.getManagedEndpointInstance(endpointClass, map);
                if (ep != null) {
                    return ep;
                }
            } else {
                ConcurrentHashMap map;
                T ep;
                InjectionProvider ip = ServiceManager.getInjectionProvider();
                if (ip != null && (ep = ip.getManagedEndpointInstance(endpointClass, map = WebSocketContainerManager.getRef().getEndpointMap())) != null) {
                    return ep;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"did not create the endpoint using the CDI service.  Will create the instance without CDI.", (Object[])new Object[0]);
            }
            return endpointClass.newInstance();
        }
        catch (IllegalAccessException ip12) {
            void e;
            FFDCFilter.processException((Throwable)ip12, (String)"com.ibm.ws.wsoc.external.WebSocketContainerExt", (String)"214", (Object)this, (Object[])new Object[]{endpointClass});
            throw new DeploymentException(e.getLocalizedMessage());
        }
        catch (InstantiationException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsoc.external.WebSocketContainerExt", (String)"216", (Object)this, (Object[])new Object[]{endpointClass});
            throw new DeploymentException(e.getLocalizedMessage());
        }
    }
}

