/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.elementdesc;

import io.smallrye.metrics.elementdesc.AnnotationInfo;
import io.smallrye.metrics.elementdesc.BeanInfo;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RawBeanInfo
implements BeanInfo {
    private String simpleName;
    private String packageName;
    private List<AnnotationInfo> annotationInfos = new ArrayList<AnnotationInfo>();
    private AnnotationInfo[] infosArray;
    private BeanInfo superClassInfo;

    public RawBeanInfo() {
    }

    public RawBeanInfo(String simpleName, String packageName, Collection<AnnotationInfo> annotationInfos, BeanInfo superClassInfo) {
        this.simpleName = simpleName;
        this.packageName = packageName;
        this.annotationInfos.addAll(annotationInfos);
        this.superClassInfo = superClassInfo;
        this.infosArray = annotationInfos.toArray(new AnnotationInfo[0]);
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public List<AnnotationInfo> getAnnotationInfos() {
        return this.annotationInfos;
    }

    public void setAnnotationInfos(List<AnnotationInfo> annotationInfos) {
        this.annotationInfos = annotationInfos;
    }

    public AnnotationInfo[] getInfosArray() {
        return this.infosArray;
    }

    public void setInfosArray(AnnotationInfo[] infosArray) {
        this.infosArray = infosArray;
    }

    public BeanInfo getSuperClassInfo() {
        return this.superClassInfo;
    }

    public void setSuperClassInfo(BeanInfo superClassInfo) {
        this.superClassInfo = superClassInfo;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public <T extends Annotation> AnnotationInfo getAnnotation(Class<T> metric) {
        return this.annotationInfos.stream().filter(annotation -> annotation.annotationName().equals(metric.getName())).findFirst().orElse(null);
    }

    @Override
    public <T extends Annotation> boolean isAnnotationPresent(Class<T> metric) {
        return this.annotationInfos.stream().anyMatch(annotation -> annotation.annotationName().equals(metric.getName()));
    }

    @Override
    public BeanInfo getSuperclass() {
        return this.superClassInfo;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BeanInfo)) {
            return false;
        }
        return this.getSimpleName().equals(((BeanInfo)obj).getSimpleName());
    }

    public int hashCode() {
        return this.getSimpleName().hashCode();
    }
}

