/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.wim.ras;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.PersonAccount;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Trivial
public class WIMTraceHelper {
    private static final String LINE_SEPARATOR;
    public static final String DUMMY_VALUE = "****";
    public static final String JAVA_STRING_CLASS = "java.lang.String";
    static HashSet systemProps;

    public static String trace(Object boundData) {
        StringBuffer strBuffer = new StringBuffer();
        try {
            WIMTraceHelper.parseObject(boundData, strBuffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strBuffer.toString();
    }

    private static void parseObject(Object boundData, StringBuffer strBuffer) throws Exception {
        strBuffer.append(boundData.getClass().getName());
        strBuffer.append("=" + LINE_SEPARATOR);
        strBuffer.append("[");
        BeanInfo beanInfo = Introspector.getBeanInfo(boundData.getClass());
        systemProps.add("setAttributes");
        systemProps.add("class");
        systemProps.add("record");
        systemProps.add("recordName");
        systemProps.add("recordShortDescription");
        systemProps.add("propertyAnnotations");
        systemProps.add("objectAnnotations");
        PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
        WIMTraceHelper.processClass(properties, systemProps, strBuffer, boundData, false);
        String className = boundData.getClass().getName();
        if ("com.ibm.wsspi.security.wim.model.PersonAccount".equals(className)) {
            Set<String> propertyNames = ((PersonAccount)boundData).getExtendedPropertyNames();
            WIMTraceHelper.processExtendedProperties((PersonAccount)boundData, propertyNames, strBuffer);
        } else if ("com.ibm.wsspi.security.wim.model.Group".equals(className)) {
            Set<String> propertyNames = ((Group)boundData).getExtendedPropertyNames();
            WIMTraceHelper.processExtendedProperties((Group)boundData, propertyNames, strBuffer);
        }
        strBuffer.append("]");
    }

    private static void processExtendedProperties(Group boundData, Set<String> propertyNames, StringBuffer strBuffer) {
        if (propertyNames == null) {
            return;
        }
        for (String propName : propertyNames) {
            if (boundData.get(propName) == null) continue;
            strBuffer.append(propName);
            strBuffer.append("=");
            strBuffer.append(boundData.get(propName));
            strBuffer.append(LINE_SEPARATOR);
        }
    }

    private static void processExtendedProperties(PersonAccount boundData, Set<String> propertyNames, StringBuffer strBuffer) {
        if (propertyNames == null) {
            return;
        }
        for (String propName : propertyNames) {
            if (boundData.get(propName) == null) continue;
            strBuffer.append(propName);
            strBuffer.append("=");
            strBuffer.append(boundData.get(propName));
            strBuffer.append(LINE_SEPARATOR);
        }
    }

    public static void processClass(PropertyDescriptor[] properties, HashSet systemProps, StringBuffer strBuffer, Object boundData, boolean isContainment) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, IntrospectionException {
        Method readMethod = null;
        Method getterMethod = null;
        Object returnValue = null;
        Object objectInsideArray = null;
        String strCurrentProp = null;
        String className = null;
        boolean isNonJavaComplexType = false;
        for (int i = 0; i < properties.length; ++i) {
            strCurrentProp = properties[i].getName();
            if ("superTypes".equals(strCurrentProp) || "typeName".equalsIgnoreCase(strCurrentProp)) continue;
            if ("password".equalsIgnoreCase(strCurrentProp)) {
                strBuffer.append(strCurrentProp);
                strBuffer.append("=");
                strBuffer.append(DUMMY_VALUE);
                strBuffer.append(LINE_SEPARATOR);
                continue;
            }
            className = properties[i].getPropertyType().getName();
            boolean bl = isNonJavaComplexType = !className.contains("java.") && !className.contains("javax.");
            if (isNonJavaComplexType && !isContainment && !WIMTraceHelper.isJavaPrimitiveType(className)) {
                Method method = properties[i].getReadMethod();
                Object memberClass = method.invoke(boundData, null);
                if (memberClass == null) continue;
                BeanInfo beanInfo = Introspector.getBeanInfo(memberClass.getClass());
                PropertyDescriptor[] propertiesContained = beanInfo.getPropertyDescriptors();
                strBuffer.append(properties[i].getPropertyType().getSimpleName());
                strBuffer.append("= {" + LINE_SEPARATOR);
                WIMTraceHelper.processClass(propertiesContained, systemProps, strBuffer, memberClass, true);
                strBuffer.append("}" + LINE_SEPARATOR);
                continue;
            }
            if (systemProps.contains(strCurrentProp)) continue;
            readMethod = properties[i].getReadMethod();
            getterMethod = boundData.getClass().getMethod(readMethod.getName(), new Class[0]);
            returnValue = getterMethod.invoke(boundData, new Object[0]);
            if (readMethod.getName().startsWith("isSet") && returnValue instanceof Boolean || returnValue == null) continue;
            boolean isHashSet = false;
            boolean isHashMap = false;
            boolean isList = false;
            int size = 0;
            if (returnValue instanceof HashSet) {
                isHashSet = true;
                size = ((HashSet)returnValue).size();
            } else if (returnValue instanceof HashMap) {
                isHashMap = true;
                size = ((HashMap)returnValue).size();
            } else if (returnValue instanceof List) {
                isList = true;
                size = ((List)returnValue).size();
            }
            if ((isHashSet || isHashMap || isList) && size == 0) continue;
            if (isContainment) {
                strBuffer.append("\t");
            }
            strBuffer.append(strCurrentProp);
            strBuffer.append("=");
            if (strCurrentProp.equalsIgnoreCase("password")) {
                strBuffer.append("*****");
            } else if (returnValue.getClass().isArray()) {
                int arrayLength = Array.getLength(returnValue);
                for (int j = 0; j < arrayLength; ++j) {
                    objectInsideArray = Array.get(returnValue, j);
                    strBuffer.append(objectInsideArray);
                    strBuffer.append(", ");
                }
                strBuffer.deleteCharAt(strBuffer.length() - 2);
            } else if (returnValue instanceof List) {
                List list = (List)returnValue;
                boolean isListAllStrings = false;
                for (int k = 0; k < list.size(); ++k) {
                    objectInsideArray = list.get(k);
                    isListAllStrings = true;
                    if (k == 0) {
                        strBuffer.append("{");
                    }
                    if (objectInsideArray instanceof PersonAccount || objectInsideArray instanceof Group) {
                        String printString = objectInsideArray.toString();
                        int startIndex = 0;
                        while (printString.indexOf(LINE_SEPARATOR, startIndex) > 0) {
                            strBuffer.append(printString.substring(startIndex, printString.indexOf(LINE_SEPARATOR, startIndex)));
                            strBuffer.append(LINE_SEPARATOR);
                            strBuffer.append("\t");
                            startIndex = printString.indexOf(LINE_SEPARATOR, startIndex) + 2;
                        }
                        strBuffer.append(printString.substring(startIndex));
                    } else {
                        strBuffer.append(objectInsideArray);
                    }
                    if (k < list.size() - 1) {
                        strBuffer.append(",");
                        continue;
                    }
                    strBuffer.append("}");
                }
            } else if (!isHashMap && !isHashSet || size != 0) {
                strBuffer.append(returnValue);
            }
            strBuffer.append(LINE_SEPARATOR);
        }
    }

    public static boolean isJavaPrimitiveType(String className) {
        boolean flag = false;
        if (className.equalsIgnoreCase("byte") || className.equalsIgnoreCase("short") || className.equalsIgnoreCase("int") || className.equalsIgnoreCase("long") || className.equalsIgnoreCase("float") || className.equalsIgnoreCase("double") || className.equalsIgnoreCase("char") || className.equalsIgnoreCase("boolean")) {
            flag = true;
        }
        return flag;
    }

    public static String printObjectArray(Object[] array) {
        if (array == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        result.append("[");
        for (int i = 0; i < array.length; ++i) {
            Object obj = array[i];
            if (obj != null) {
                if (obj instanceof Object[]) {
                    result.append(WIMTraceHelper.printObjectArray((Object[])obj));
                } else {
                    result.append(obj);
                }
            } else {
                result.append("null");
            }
            if (i == array.length - 1) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    public static String printPrimitiveArray(Object obj) {
        Comparable<Byte>[] oArray;
        block10: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block9: {
                                        if (obj == null) {
                                            return null;
                                        }
                                        oArray = null;
                                        if (!(obj instanceof byte[])) break block9;
                                        byte[] pArray = (byte[])obj;
                                        oArray = new Byte[pArray.length];
                                        for (int idx = 0; idx < pArray.length; ++idx) {
                                            oArray[idx] = pArray[idx];
                                        }
                                        break block10;
                                    }
                                    if (!(obj instanceof char[])) break block11;
                                    char[] pArray = (char[])obj;
                                    oArray = new Character[pArray.length];
                                    for (int idx = 0; idx < pArray.length; ++idx) {
                                        oArray[idx] = Character.valueOf(pArray[idx]);
                                    }
                                    break block10;
                                }
                                if (!(obj instanceof double[])) break block12;
                                double[] pArray = (double[])obj;
                                oArray = new Double[pArray.length];
                                for (int idx = 0; idx < pArray.length; ++idx) {
                                    oArray[idx] = pArray[idx];
                                }
                                break block10;
                            }
                            if (!(obj instanceof float[])) break block13;
                            float[] pArray = (float[])obj;
                            oArray = new Float[pArray.length];
                            for (int idx = 0; idx < pArray.length; ++idx) {
                                oArray[idx] = Float.valueOf(pArray[idx]);
                            }
                            break block10;
                        }
                        if (!(obj instanceof int[])) break block14;
                        int[] pArray = (int[])obj;
                        oArray = new Integer[pArray.length];
                        for (int idx = 0; idx < pArray.length; ++idx) {
                            oArray[idx] = pArray[idx];
                        }
                        break block10;
                    }
                    if (!(obj instanceof short[])) break block15;
                    short[] pArray = (short[])obj;
                    oArray = new Short[pArray.length];
                    for (int idx = 0; idx < pArray.length; ++idx) {
                        oArray[idx] = pArray[idx];
                    }
                    break block10;
                }
                if (!(obj instanceof long[])) break block16;
                long[] pArray = (long[])obj;
                oArray = new Long[pArray.length];
                for (int idx = 0; idx < pArray.length; ++idx) {
                    oArray[idx] = pArray[idx];
                }
                break block10;
            }
            if (!(obj instanceof boolean[])) break block10;
            boolean[] pArray = (boolean[])obj;
            oArray = new Boolean[pArray.length];
            for (int idx = 0; idx < pArray.length; ++idx) {
                oArray[idx] = pArray[idx];
            }
        }
        return WIMTraceHelper.printObjectArray(oArray);
    }

    public static String printMapWithoutPassword(Map<String, Object> map) {
        if (map == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        Iterator<Map.Entry<String, Object>> itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, Object> entry = itr.next();
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key != null && key.toLowerCase().indexOf("password") >= 0) {
                value = DUMMY_VALUE;
            }
            if (itr.hasNext()) {
                sb.append("[" + key + "=" + value + "],");
                continue;
            }
            sb.append("[" + key + "=" + value + "]");
        }
        return sb.toString();
    }

    static {
        systemProps = new HashSet();
        LINE_SEPARATOR = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 4446075164449067662L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty("line.separator");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.websphere.security.wim.ras.WIMTraceHelper$1", 1.class, null, null);
            }
        });
    }
}

