/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.utility.tasks;

import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.security.utility.IFileUtility;
import com.ibm.ws.security.utility.SecurityUtilityReturnCodes;
import com.ibm.ws.security.utility.tasks.BaseCommandTask;
import com.ibm.ws.security.utility.utils.ConsoleWrapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringJoiner;
import org.apache.commons.io.FilenameUtils;

public class ConfigureFIPSTask
extends BaseCommandTask {
    static final String SLASH = String.valueOf(File.separatorChar);
    static final String PATH_SEPARATOR = File.pathSeparator;
    static final String ARG_SERVER = "--server";
    static final String ARG_CLIENT = "--client";
    static final String ARG_DISABLE = "--disable";
    static final String ARG_CUSTOMPROFILE_FILE = "--customProfileFile";
    static final String DEFAULT_ENV = "default.env";
    static final String SERVER_ENV = "server.env";
    static final String CLIENT_ENV = "client.env";
    static final String ENABLE_FIPS140_3_ENV_VAR = "ENABLE_FIPS140_3";
    static final String LIBERTY_PROFILE_FILE_NAME = "FIPS140-3-Liberty.properties";
    static final String APP_PROFILE_FILE_NAME = "FIPS140-3-Liberty-Application.properties";
    static final String PROFILE_NAME_HOLDER = "PROFILE_NAME_HOLDER";
    static final String BASE_PROFILE_NAME_HOLDER = "BASE_NAME_HOLDER";
    final String APP_PROFILE = String.join((CharSequence)NL, "# Visit the link for more information about configuring this file:", "# https://ibm.biz/BdeU7c", "#", "# To find the FIPS140-3-Liberty profile configuration, see wlp/lib/security/fips140_3/FIPS140-3-Liberty.properties", "#", "# Example configuration to add for allowing SHA-1 for the io.openliberty.myClass class in the existing OpenJCEPlusFIPS provider:", "# RestrictedSecurity.OpenJCEPlusFIPS.PROFILE_NAME_HOLDER.jce.provider.1 = com.ibm.crypto.plus.provider.OpenJCEPlusFIPS [+ \\", "#     {MessageDigest, SHA-1, *, FullClassName:io.openliberty.myClass}]", "#", "# Example configuration to add for registering a new io.openliberty.myProvider provider:", "# RestrictedSecurity.OpenJCEPlusFIPS.PROFILE_NAME_HOLDER.jce.provider.51 = io.openliberty.myProvider", "#", "RestrictedSecurity.OpenJCEPlusFIPS.PROFILE_NAME_HOLDER.desc.name = OpenJCEPlusFIPS Cryptographic Module FIPS 140-3 for Liberty Application", "RestrictedSecurity.OpenJCEPlusFIPS.PROFILE_NAME_HOLDER.extends = RestrictedSecurity.OpenJCEPlusFIPS.BASE_NAME_HOLDER", "");
    protected ConsoleWrapper stdin;
    protected PrintStream stdout;
    protected PrintStream stderr;
    private final IFileUtility fileUtility;
    private final String osName = System.getProperty("os.name");
    private final boolean isZOS = this.osName.equalsIgnoreCase("z/OS") || this.osName.equalsIgnoreCase("OS/390");
    private final Charset CHARSET = this.isZOS ? Charset.forName("IBM1047") : StandardCharsets.UTF_8;
    private boolean isIbmSdkChecked = false;
    private boolean isIbmSdk = false;
    private boolean isSemeruChecked = false;
    private boolean isSemeru = false;

    public ConfigureFIPSTask(IFileUtility fileUtility, String scriptName) {
        super(scriptName);
        this.fileUtility = fileUtility;
    }

    @Override
    public String getTaskName() {
        return "configureFIPS";
    }

    @Override
    public String getTaskHelp() {
        return this.getTaskHelp("configureFIPS.desc", "configureFIPS.usage.options", "configureFIPS.required-key.", "configureFIPS.required-desc.", "configureFIPS.option-key", "configureFIPS.option-desc", null, null, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("configureFIPS.desc", true, new Object[0]);
    }

    @Override
    public SecurityUtilityReturnCodes handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws Exception {
        SecurityUtilityReturnCodes rc;
        String customProfileFilePaths;
        String envFileLocation;
        SecurityUtilityReturnCodes rc2;
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        if (ProductInfo.getBetaEdition()) {
            stdout.println("BETA: The SecurityUtility configureFIPS task is only available in beta." + NL);
        }
        String serverName = this.getArgumentValue(ARG_SERVER, args, null);
        String clientName = this.getArgumentValue(ARG_CLIENT, args, null);
        String customProfileFile = this.getArgumentValue(ARG_CUSTOMPROFILE_FILE, args, null);
        boolean disable = Arrays.asList(args).contains(ARG_DISABLE);
        if (this.isZOS) {
            stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.zosNotAvailable", new Object[0]));
            return SecurityUtilityReturnCodes.ERR_GENERIC;
        }
        try {
            if (!(disable || this.isIbmSdk() || this.isSemeru())) {
                stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.notIbmSdkNorSemeru", new Object[0]));
                return SecurityUtilityReturnCodes.ERR_GENERIC;
            }
        }
        catch (IOException e) {
            stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.abort", new Object[0]));
            e.printStackTrace(stdout);
            return SecurityUtilityReturnCodes.ERR_GENERIC;
        }
        if (serverName == null && clientName == null) {
            String etcDir = this.fileUtility.getInstallDirectory() + "etc" + SLASH;
            String envFileLocation2 = this.fileUtility.resolvePath(etcDir + DEFAULT_ENV);
            if (disable) {
                SecurityUtilityReturnCodes rc3 = this.handleFileToDisableFips(envFileLocation2, null, null);
                if (rc3 != SecurityUtilityReturnCodes.OK) {
                    return rc3;
                }
            } else {
                String customProfileFilePaths2 = "";
                if (this.isSemeru() && (customProfileFilePaths2 = customProfileFile) == null) {
                    customProfileFilePaths2 = etcDir + APP_PROFILE_FILE_NAME;
                }
                if ((rc2 = this.handleFilesToEnableFips(envFileLocation2, customProfileFilePaths2, null, null)) != SecurityUtilityReturnCodes.OK) {
                    return rc2;
                }
            }
        }
        if (serverName != null) {
            String usrServers = this.fileUtility.getServersDirectory();
            String serverDir = usrServers + serverName + SLASH;
            if (!this.fileUtility.exists(serverDir)) {
                usrServers = this.fileUtility.resolvePath(usrServers);
                stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.abort", new Object[0]));
                stdout.println(ConfigureFIPSTask.getMessage("serverNotFound", serverName, usrServers));
                return SecurityUtilityReturnCodes.ERR_SERVER_NOT_FOUND;
            }
            envFileLocation = this.fileUtility.resolvePath(serverDir + SLASH + SERVER_ENV);
            if (disable) {
                rc2 = this.handleFileToDisableFips(envFileLocation, serverName, null);
                if (rc2 != SecurityUtilityReturnCodes.OK) {
                    return rc2;
                }
            } else {
                customProfileFilePaths = "";
                if (this.isSemeru() && (customProfileFilePaths = customProfileFile) == null) {
                    customProfileFilePaths = serverDir + "resources" + SLASH + "security" + SLASH + APP_PROFILE_FILE_NAME;
                }
                if ((rc = this.handleFilesToEnableFips(envFileLocation, customProfileFilePaths, serverName, null)) != SecurityUtilityReturnCodes.OK) {
                    return rc;
                }
            }
        }
        if (clientName != null) {
            String usrClients;
            String clientDir;
            if (serverName != null) {
                stdout.println("");
            }
            if (!this.fileUtility.exists(clientDir = (usrClients = this.fileUtility.getClientsDirectory()) + clientName + SLASH)) {
                usrClients = this.fileUtility.resolvePath(usrClients);
                stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.abort", new Object[0]));
                stdout.println(ConfigureFIPSTask.getMessage("clientNotFound", clientName, usrClients));
                return SecurityUtilityReturnCodes.ERR_CLIENT_NOT_FOUND;
            }
            envFileLocation = this.fileUtility.resolvePath(clientDir + SLASH + CLIENT_ENV);
            if (disable) {
                rc2 = this.handleFileToDisableFips(envFileLocation, null, clientName);
                if (rc2 != SecurityUtilityReturnCodes.OK) {
                    return rc2;
                }
            } else {
                customProfileFilePaths = "";
                if (this.isSemeru() && (customProfileFilePaths = customProfileFile) == null) {
                    customProfileFilePaths = clientDir + "resources" + SLASH + "security" + SLASH + APP_PROFILE_FILE_NAME;
                }
                if ((rc = this.handleFilesToEnableFips(envFileLocation, customProfileFilePaths, null, clientName)) != SecurityUtilityReturnCodes.OK) {
                    return rc;
                }
            }
        }
        return SecurityUtilityReturnCodes.OK;
    }

    private boolean isSemeru() throws IOException {
        if (this.isSemeruChecked) {
            return this.isSemeru;
        }
        this.isIbmSdk = this.isIbmSdk();
        if (this.isIbmSdk) {
            this.isSemeru = false;
            this.isSemeruChecked = true;
            return this.isSemeru;
        }
        this.isSemeru = false;
        String javaHome = this.getJavaHome();
        String javaSecurity = javaHome + (javaHome.endsWith(SLASH) ? "" : SLASH) + "conf" + SLASH + "security" + SLASH + "java.security";
        if (this.fileUtility.exists(javaSecurity)) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(javaSecurity), this.CHARSET));){
                String line = "";
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("RestrictedSecurity.OpenJCEPlusFIPS.FIPS140-3-Strongly-Enforced.")) continue;
                    this.isSemeru = true;
                    break;
                }
            }
        }
        this.isSemeruChecked = true;
        return this.isSemeru;
    }

    private boolean isIbmSdk() {
        if (this.isIbmSdkChecked) {
            return this.isIbmSdk;
        }
        this.isIbmSdk = false;
        String javaHome = this.getJavaHome();
        this.isIbmSdk = javaHome.endsWith("jre" + SLASH) ? this.fileUtility.exists(javaHome + "fips140-3" + SLASH) : (javaHome.endsWith("jre") ? this.fileUtility.exists(javaHome + SLASH + "fips140-3" + SLASH) : (javaHome.endsWith(SLASH) ? this.fileUtility.exists(javaHome + "jre" + SLASH + "fips140-3" + SLASH) : this.fileUtility.exists(javaHome + SLASH + "jre" + SLASH + "fips140-3" + SLASH)));
        this.isIbmSdkChecked = true;
        return this.isIbmSdk;
    }

    private String getJavaHome() {
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome == null) {
            javaHome = System.getenv("JRE_HOME");
        }
        if (javaHome == null) {
            javaHome = System.getenv("WLP_DEFAULT_JAVA_HOME");
        }
        if (javaHome == null) {
            javaHome = System.getProperty("java.home");
        }
        return javaHome;
    }

    private SecurityUtilityReturnCodes handleFilesToEnableFips(String envFileLocation, String customProfileFilePaths, String serverName, String clientName) {
        if (customProfileFilePaths.isEmpty()) {
            this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.configureIbmSdk", new Object[0]));
            customProfileFilePaths = "true";
        } else {
            this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.configureSemeru", new Object[0]));
            CharSequence[] customProfileFileLocations = customProfileFilePaths.split(PATH_SEPARATOR);
            File previousCustomProfileFile = null;
            for (int i = 0; i < customProfileFileLocations.length; ++i) {
                customProfileFileLocations[i] = this.fileUtility.resolvePath((String)customProfileFileLocations[i]);
                CharSequence customProfileFileLocation = customProfileFileLocations[i];
                File customProfileFile = new File((String)customProfileFileLocation);
                String profileName = FilenameUtils.removeExtension((String)customProfileFile.getName());
                if (profileName.equals("FIPS140-3-Liberty")) {
                    this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.fileNameNotAllowed", customProfileFileLocation));
                    return SecurityUtilityReturnCodes.ERR_GENERIC;
                }
                if (!this.fileUtility.createParentDirectory(this.stdout, customProfileFile)) {
                    this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.abortSemeruFile", new Object[0]));
                    this.stdout.println(ConfigureFIPSTask.getMessage("file.requiredDirNotCreated", customProfileFileLocation));
                    return SecurityUtilityReturnCodes.ERR_PATH_CANNOT_BE_CREATED;
                }
                if (this.fileUtility.exists(customProfileFile)) {
                    this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.fileExists", customProfileFileLocation));
                    previousCustomProfileFile = customProfileFile;
                    continue;
                }
                String baseProfileName = FilenameUtils.removeExtension((String)(previousCustomProfileFile == null ? LIBERTY_PROFILE_FILE_NAME : previousCustomProfileFile.getName()));
                String customProfile = this.APP_PROFILE.replaceAll(PROFILE_NAME_HOLDER, profileName).replaceAll(BASE_PROFILE_NAME_HOLDER, baseProfileName);
                this.fileUtility.writeToFile(this.stderr, customProfile, customProfileFile);
                this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.createdSemeruFile", customProfileFileLocation));
                previousCustomProfileFile = customProfileFile;
            }
            customProfileFilePaths = String.join((CharSequence)PATH_SEPARATOR, customProfileFileLocations);
        }
        File envFile = new File(envFileLocation);
        if (!this.fileUtility.createParentDirectory(this.stdout, envFile)) {
            this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.abortEnvFile", new Object[0]));
            this.stdout.println(ConfigureFIPSTask.getMessage("file.requiredDirNotCreated", envFileLocation));
            return SecurityUtilityReturnCodes.ERR_PATH_CANNOT_BE_CREATED;
        }
        return this.setFipsEnvironmentVariable(envFile, customProfileFilePaths, serverName, clientName);
    }

    private SecurityUtilityReturnCodes handleFileToDisableFips(String envFileLocation, String serverName, String clientName) {
        File envFile = new File(envFileLocation);
        return this.disableFipsEnvironmentVariable(envFile, serverName, clientName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SecurityUtilityReturnCodes setFipsEnvironmentVariable(File file, String value, String serverName, String clientName) {
        if (!this.fileUtility.exists(file)) {
            this.fileUtility.writeToFile(this.stderr, "ENABLE_FIPS140_3=" + value + NL, file);
            this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.createdEnvFileToEnableFips", this.fileUtility.resolvePath(file)));
            this.printRestartServerMessage(serverName, clientName);
            return SecurityUtilityReturnCodes.OK;
        }
        boolean enabled = false;
        ArrayList<String> lines = new ArrayList<String>();
        boolean fileEndsWithNewLineChar = false;
        boolean variableExpansionEnabled = false;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileUtility.resolvePath(file)), this.CHARSET));){
            Object line = "";
            while ((line = reader.readLine()) != null) {
                if (((String)line).replaceAll("\\s", "").equalsIgnoreCase("#enable_variable_expansion")) {
                    variableExpansionEnabled = true;
                }
                if (((String)line).startsWith("ENABLE_FIPS140_3=")) {
                    if (!((String)line).equals("ENABLE_FIPS140_3=false")) {
                        this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.abortEnvFile", new Object[0]));
                        this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.fipsAlreadyEnabled", this.fileUtility.resolvePath(file)));
                        SecurityUtilityReturnCodes securityUtilityReturnCodes = SecurityUtilityReturnCodes.ERR_GENERIC;
                        return securityUtilityReturnCodes;
                    }
                    lines.add("ENABLE_FIPS140_3=" + value);
                    enabled = true;
                    continue;
                }
                lines.add((String)line);
            }
            fileEndsWithNewLineChar = this.fileEndsOnNewLine(file);
        }
        catch (IOException e) {
            this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.abortEnvFile", new Object[0]));
            e.printStackTrace(this.stdout);
            return SecurityUtilityReturnCodes.ERR_GENERIC;
        }
        if (!enabled) {
            lines.add("ENABLE_FIPS140_3=" + value);
        }
        StringJoiner joiner = new StringJoiner(NL);
        for (String line : lines) {
            String envVarValue;
            String envVarKey;
            String[] keyValue;
            if (variableExpansionEnabled && (keyValue = line.split("=", 2)).length == 2 && (envVarKey = keyValue[0]).equals(ENABLE_FIPS140_3_ENV_VAR) && (envVarValue = keyValue[1]).contains(" ")) {
                line = envVarKey + "=\"" + envVarValue + "\"";
            }
            joiner.add(line);
        }
        try {
            this.backupFile(file);
            this.fileUtility.writeToFile(this.stderr, joiner.toString() + (fileEndsWithNewLineChar ? NL : ""), file, this.CHARSET);
            this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.updatedEnvFileToEnableFips", this.fileUtility.resolvePath(file)));
            this.printRestartServerMessage(serverName, clientName);
            return SecurityUtilityReturnCodes.OK;
        }
        catch (IOException e) {
            this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.abortEnvFile", new Object[0]));
            e.printStackTrace(this.stdout);
            return SecurityUtilityReturnCodes.ERR_GENERIC;
        }
    }

    private SecurityUtilityReturnCodes disableFipsEnvironmentVariable(File file, String serverName, String clientName) {
        if (!this.fileUtility.exists(file)) {
            this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.abortEnvFile", new Object[0]));
            this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.fileDoesNotExist", this.fileUtility.resolvePath(file)));
            return SecurityUtilityReturnCodes.ERR_GENERIC;
        }
        boolean disabled = false;
        StringJoiner joiner = new StringJoiner(NL);
        boolean fileEndsWithNewLineChar = false;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileUtility.resolvePath(file)), this.CHARSET));){
            String line = "";
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("ENABLE_FIPS140_3=") && !line.equals("ENABLE_FIPS140_3=false")) {
                    joiner.add("ENABLE_FIPS140_3=false");
                    disabled = true;
                    continue;
                }
                joiner.add(line);
            }
            fileEndsWithNewLineChar = this.fileEndsOnNewLine(file);
        }
        catch (IOException e) {
            this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.abortEnvFile", new Object[0]));
            e.printStackTrace(this.stdout);
            return SecurityUtilityReturnCodes.ERR_GENERIC;
        }
        if (!disabled) {
            this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.abortEnvFile", new Object[0]));
            this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.fipsNotEnabled", this.fileUtility.resolvePath(file)));
            return SecurityUtilityReturnCodes.ERR_GENERIC;
        }
        try {
            this.backupFile(file);
            this.fileUtility.writeToFile(this.stderr, joiner.toString() + (fileEndsWithNewLineChar ? NL : ""), file, this.CHARSET);
            this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.updatedEnvFileToDisableFips", this.fileUtility.resolvePath(file)));
            this.printRestartServerMessage(serverName, clientName);
            return SecurityUtilityReturnCodes.OK;
        }
        catch (IOException e) {
            this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.abortEnvFile", new Object[0]));
            e.printStackTrace(this.stdout);
            return SecurityUtilityReturnCodes.ERR_GENERIC;
        }
    }

    private boolean fileEndsOnNewLine(File file) throws IOException {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.fileUtility.resolvePath(file), "r");){
            long lastByteIdx = randomAccessFile.length() - 1L;
            if (lastByteIdx == -1L) {
                boolean bl = true;
                return bl;
            }
            randomAccessFile.seek(lastByteIdx);
            if (this.isZOS) {
                boolean bl = randomAccessFile.read() == 21;
                return bl;
            }
            boolean bl = randomAccessFile.read() == 10;
            return bl;
        }
    }

    private void printRestartServerMessage(String serverName, String clientName) {
        if (serverName != null) {
            this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.restartServer", serverName));
        } else if (clientName != null) {
            this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.restartClient", clientName));
        } else {
            this.stdout.println(ConfigureFIPSTask.getMessage("configureFIPS.restart", new Object[0]));
        }
    }

    private void backupFile(File file) throws IOException {
        if (file.length() == 0L) {
            return;
        }
        File backupFile = new File(this.fileUtility.resolvePath(file) + ".backup");
        Files.copy(file.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    boolean isKnownArgument(String arg) {
        return arg.equals(ARG_SERVER) || arg.equals(ARG_CLIENT) || arg.equals(ARG_DISABLE) || arg.equals(ARG_CUSTOMPROFILE_FILE);
    }

    @Override
    void checkRequiredArguments(String[] args) throws IllegalArgumentException {
        String message = "";
        if (args.length < 1) {
            message = ConfigureFIPSTask.getMessage("insufficientArgs", new Object[0]);
        }
        if (!message.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    private String getArgumentValue(String arg, String[] args, String defalt) {
        return this.getArgumentValue(arg, args, defalt, null, this.stdin, this.stdout);
    }
}

