/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.matching;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.processor.MPSelectorEvaluator;
import com.ibm.ws.sib.processor.matching.MessageProcessorMatching;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;

public class MPSelectorEvaluatorImpl
implements MPSelectorEvaluator {
    private static final TraceComponent tc = SibTr.register(MPSelectorEvaluatorImpl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MessageProcessorMatching mpm = null;

    public MPSelectorEvaluatorImpl() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MPSelectorEvaluatorImpl");
        }
        this.mpm = new MessageProcessorMatching();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MPSelectorEvaluatorImpl", (Object)this);
        }
    }

    public Selector parseSelector(String selectorString, SelectorDomain domain) throws SISelectorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"parseSelector", (Object)new Object[]{selectorString, domain});
        }
        Selector selectorTree = this.mpm.parseSelector(selectorString, domain);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"parseSelector", (Object)selectorTree);
        }
        return selectorTree;
    }

    public Selector parseDiscriminator(String discriminator) throws SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"parseDiscriminator", (Object)discriminator);
        }
        Selector discriminatorTree = this.mpm.parseDiscriminator(discriminator);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"parseDiscriminator", (Object)discriminatorTree);
        }
        return discriminatorTree;
    }

    public boolean evaluateMessage(Selector selectorTree, Selector discriminatorTree, SIBusMessage msg) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"evaluateMessage", (Object)new Object[]{selectorTree, discriminatorTree, msg});
        }
        boolean ret = this.mpm.evaluateMessage(selectorTree, discriminatorTree, msg);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"evaluateMessage", (Object)new Boolean(ret));
        }
        return ret;
    }

    public boolean evaluateDiscriminator(String fullTopic, String wildcardTopic) throws SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"evaluateDiscriminator", (Object)new Object[]{fullTopic, wildcardTopic});
        }
        boolean ret = this.mpm.evaluateDiscriminator(fullTopic, wildcardTopic);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"evaluateDiscriminator", (Object)new Boolean(ret));
        }
        return ret;
    }
}

