/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.xml.ws.Provider;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.spi.Invoker;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.invoker.Factory;
import org.apache.cxf.service.invoker.SingletonFactory;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class JAXWSMethodInvoker
extends AbstractJAXWSMethodInvoker {
    private static final Logger LOG = LogUtils.getLogger(JAXWSMethodInvoker.class);
    public static final String COPY_SOAP_HEADERS_BY_FAULT = "org.apache.cxf.fault.copySoapHeaders";
    Invoker invoker;
    static final long serialVersionUID = 6913828128188075286L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXWSMethodInvoker(Object bean) {
        super((Factory)new SingletonFactory(bean));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JAXWSMethodInvoker", "<init>", new Object[]{bean});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.JAXWSMethodInvoker", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXWSMethodInvoker(Factory factory) {
        super(factory);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JAXWSMethodInvoker", "<init>", new Object[]{factory});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.JAXWSMethodInvoker", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXWSMethodInvoker(Invoker i) {
        super(null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JAXWSMethodInvoker", "<init>", new Object[]{i});
        }
        this.invoker = i;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.JAXWSMethodInvoker", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Object performInvocation(Exchange exchange, Object serviceObject, Method m, Object[] paramArray) throws Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JAXWSMethodInvoker", "performInvocation", new Object[]{exchange, serviceObject, m, paramArray});
        }
        if (this.invoker != null) {
            Object object = this.invoker.invoke(m, paramArray);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                object = object;
                LOG.exiting("org.apache.cxf.jaxws.JAXWSMethodInvoker", "performInvocation", object);
            }
            return object;
        }
        Object object = super.performInvocation(exchange, serviceObject, m, paramArray);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxws.JAXWSMethodInvoker", "performInvocation", object);
        }
        return object;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Object invoke(Exchange exchange, Object serviceObject, Method m, List<Object> params) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JAXWSMethodInvoker", "invoke", new Object[]{exchange, serviceObject, m, params});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        WrappedMessageContext ctx = new WrappedMessageContext(exchange.getInMessage(), MessageContext.Scope.APPLICATION);
        Map<String, Object> handlerScopedStuff = this.removeHandlerProperties(ctx);
        MessageContext oldCtx = WebServiceContextImpl.setMessageContext(ctx);
        List res = null;
        if (isFinestEnabled) {
            LOG.finest("Is serviceObject instanceof Provider: " + (serviceObject instanceof Provider));
        }
        try {
            if ((params == null || params.isEmpty()) && serviceObject instanceof Provider) {
                params = Collections.singletonList(null);
            }
            res = CastUtils.cast((List)((List)super.invoke(exchange, serviceObject, m, params)));
            if (serviceObject instanceof Provider && MessageUtils.getContextualBoolean((Message)exchange.getInMessage(), (String)"jaxws.provider.interpretNullAsOneway", (boolean)true) && res != null && !res.isEmpty() && res.get(0) == null && exchange.getInMessage().getInterceptorChain().getState() == InterceptorChain.State.EXECUTING) {
                res = null;
                this.changeToOneway(exchange);
                params = Collections.singletonList(null);
                if (isFinestEnabled) {
                    LOG.finest("Exchange is set to be one way.");
                }
            }
            this.updateWebServiceContext(exchange, ctx);
        }
        catch (Fault f) {
            if (MessageUtils.getContextualBoolean((Message)exchange.getInMessage(), (String)COPY_SOAP_HEADERS_BY_FAULT, (boolean)true)) {
                this.updateHeader(exchange, ctx);
            }
            throw f;
        }
        finally {
            if (oldCtx == null) {
                WebServiceContextImpl.clear();
            } else {
                WebServiceContextImpl.setMessageContext(oldCtx);
            }
            this.addHandlerProperties(ctx, handlerScopedStuff);
        }
        List list = res;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxws.JAXWSMethodInvoker", "invoke", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void changeToOneway(Exchange exchange) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.JAXWSMethodInvoker", "changeToOneway", new Object[]{exchange});
        }
        exchange.setOneWay(true);
        exchange.setOutMessage(null);
        HttpServletResponse httpresp = (HttpServletResponse)exchange.getInMessage().get((Object)"HTTP.RESPONSE");
        if (httpresp != null) {
            httpresp.setStatus(202);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.JAXWSMethodInvoker", "changeToOneway");
        }
    }
}

