/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChunkedMessageWrapper {
    private ArrayList<DataSlice> slices = new ArrayList();
    private SITransaction transaction = null;
    private ProducerSession producerSession = null;
    private SICoreConnection connection = null;
    private DestinationType destinationType = null;
    private SIDestinationAddress destinationAddress = null;
    private OrderingContext orderingContext = null;
    private String alternateUser = null;
    private int reason = 0;
    private String[] messageInserts = null;
    private Mode state = null;

    public ChunkedMessageWrapper(SITransaction transaction, ProducerSession producerSession) {
        this.transaction = transaction;
        this.producerSession = producerSession;
        this.state = Mode.PRODUCER_SEND;
    }

    public ChunkedMessageWrapper(SITransaction transaction, SICoreConnection connection, DestinationType destinationType, SIDestinationAddress destinationAddress, OrderingContext orderingContext, String alternateUser) {
        this.transaction = transaction;
        this.connection = connection;
        this.destinationType = destinationType;
        this.destinationAddress = destinationAddress;
        this.orderingContext = orderingContext;
        this.alternateUser = alternateUser;
        this.state = Mode.CONN_SEND;
    }

    public ChunkedMessageWrapper(SITransaction transaction, SICoreConnection connection, SIDestinationAddress destinationAddress, int reason, String alternateUser, String[] inserts) {
        this.transaction = transaction;
        this.connection = connection;
        this.destinationAddress = destinationAddress;
        this.reason = reason;
        this.alternateUser = alternateUser;
        this.messageInserts = inserts;
        this.state = Mode.CONN_SEND_TO_EXCEPTION;
    }

    public ProducerSession getProducerSession() {
        return this.producerSession;
    }

    public List<DataSlice> getMessageData() {
        return this.slices;
    }

    public void addDataSlice(DataSlice slice) {
        this.slices.add(slice);
    }

    public SITransaction getTransaction() {
        return this.transaction;
    }

    public SICoreConnection getConnection() {
        return this.connection;
    }

    public SIDestinationAddress getDestinationAddress() {
        return this.destinationAddress;
    }

    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    public OrderingContext getOrderingContext() {
        return this.orderingContext;
    }

    public String getAlternateUser() {
        return this.alternateUser;
    }

    public String[] getMessageInserts() {
        return this.messageInserts;
    }

    public int getReason() {
        return this.reason;
    }

    public int getTotalMessageLength() {
        int msgLength = 0;
        for (DataSlice slice : this.slices) {
            msgLength += slice.getLength();
        }
        return msgLength;
    }

    public String toString() {
        String toString = "ChunkedMessageWrapper@" + Integer.toHexString(System.identityHashCode(this)) + " [Mode=" + (Object)((Object)this.state) + "]: ";
        if (this.state == Mode.PRODUCER_SEND) {
            toString = toString + "{ transaction=" + this.transaction + ", producerSession=" + this.producerSession + " }";
        } else if (this.state == Mode.CONN_SEND) {
            toString = toString + "{ transaction=" + this.transaction + ", producerSession=" + this.producerSession + ", destinationType=" + this.destinationType + ", destinationAddress=" + this.destinationAddress + ", orderingContext=" + this.orderingContext + ", alternateUser=" + this.alternateUser + " }";
        } else if (this.state == Mode.CONN_SEND_TO_EXCEPTION) {
            toString = toString + "{ transaction=" + this.transaction + ", producerSession=" + this.producerSession + ", destinationAddress=" + this.destinationAddress + ", reason=" + this.reason + ", alternateUser=" + this.alternateUser + ", inserts=" + Arrays.toString(this.messageInserts) + " }";
        }
        return toString;
    }

    private static enum Mode {
        PRODUCER_SEND,
        CONN_SEND,
        CONN_SEND_TO_EXCEPTION;

    }
}

